% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/morey_plots.R
\name{morey_plot.ttest}
\alias{morey_plot.ttest}
\alias{morey_plot.ftest}
\title{Plot out power sensitivity plots for t or F tests}
\usage{
morey_plot.ttest(
  es = seq(0, 1, 0.05),
  n = NULL,
  type = c("two.sample", "one.sample", "paired"),
  alternative = c("two.sided", "one.sided"),
  alpha_level = Superpower_options("alpha_level")
)

morey_plot.ftest(
  es = seq(0, 1, 0.05),
  num_df = 1,
  den_df = NULL,
  alpha_level = Superpower_options("alpha_level"),
  liberal_lambda = Superpower_options("liberal_lambda")
)
}
\arguments{
\item{es}{Effect size magnitudes to include on the plot; either cohen's f or cohen's d depending on whether it is an F-test or t-test}

\item{n}{Sample size (t-test only) per group (two sample), total number of pairs (paired samples), or total observations (one-sample); only applies to t-test}

\item{type}{string specifying the type of t test. Can be abbreviated. (t-test only)}

\item{alternative}{one- or two-sided test. Can be abbreviated. (t-test only)}

\item{alpha_level}{vector of alpha levels; default is 0.05}

\item{num_df}{Numerator degrees of freedom for an F-test.}

\item{den_df}{Denominator degrees of freedom for an F-test.}

\item{liberal_lambda}{Logical indicator of whether to use the liberal (cohen_f^2\*(num_df+den_df)) or conservative (cohen_f^2\*den_df) calculation of the noncentrality (lambda) parameter estimate. Default is FALSE.}
}
\value{
Returns plots of effect size (x-axis)
}
\description{
Plot out power sensitivity plots for t or F tests
}
\section{Functions}{
\itemize{
\item \code{morey_plot.ttest}: Power-sensitivity plot for t-tests

\item \code{morey_plot.ftest}: Power-sensitivity plot for F-tests
}}

\section{References}{

Morey, R.D. (2020). Power and precision Why the push for replacing “power” with “precision” is misguided. Retrieved from: \url{https://richarddmorey.medium.com/power-and-precision-47f644ddea5e}
}

\examples{
\dontrun{
# t-test example ------
# Sensitivity for cohen's d from .1 to .5
# sample sizes of 10 and 20
# alpha levels .05 and .075
# type will be paired and one sided
# Set effect sizes with seq function (?seq)

morey_plot.ttest(es = seq(.1,.5,.01),
n = c(10,20),
alpha_level = c(.05,.075),
type = "paired",
alternative = "one.sided")
}
}
