% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDrugMatrix.R
\name{getDrugMatrix}
\alias{getDrugMatrix}
\title{SubtypeDrug internal function}
\usage{
getDrugMatrix(spw_matrix, drug_target_data, weighted.score)
}
\arguments{
\item{spw_matrix}{A subpathway activity profile. rows are subpathwyas, columns are samples.}

\item{drug_target_data}{A list. A list stores a collection of drug up- and down-regulated subpathways.}

\item{weighted.score}{A binary value of 0 or 1. If the `weighted.score` = 1, the drug reverse association score will be weighted by the subpathway activity.}
}
\value{
A matrix.
}
\description{
Obtaining drug-disease reverse association score matrix.
}
\details{
getDrugMatrix
}
\examples{
require(GSVA)
Geneexp<-get("GeneexpT")
UserDS<-get("UserDST")
UserGS<-get("UserGST")
gsvapar <- gsvaParam(Geneexp, UserGS)
spw_matrix<-gsva(gsvapar)
x<-getDrugMatrix(spw_matrix,UserDS,weighted.score=FALSE)
}
\author{
Xudong Han,
Junwei Han,
Chonghui Liu
}
