% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05-forest-plot-function.r
\name{plot_forest}
\alias{plot_forest}
\title{Forest plot for subgroup effect size}
\usage{
plot_forest(
  dat,
  covari.sel,
  trt.sel,
  resp.sel,
  outcome.type,
  size.shape = c(0.25, 0.12),
  font.size = c(1.3, 1, 0.85, 0.9),
  title = NULL,
  lab.x = NULL,
  time = mean(dat[, resp.sel[1]]),
  KM = FALSE,
  show.km.axis = TRUE,
  widths = c(1, 1, 1),
  max.time = NULL,
  n.brk = 10,
  trt.labels = c("Treatment", "Control"),
  panel.titles = c("Eff.size", "95\% CI", "S.Size(T|C)"),
  eff.scale = c("logHR", "HR")
)
}
\arguments{
\item{dat}{a data set}

\item{covari.sel}{a vector of indices of the two covariates}

\item{trt.sel}{a covariate index specifying the treatment code}

\item{resp.sel}{a covariate index specifying the response variable}

\item{outcome.type}{a string specifying the type of the response variable, it can be "continuous", or "binary" or  "survival".}

\item{size.shape}{a vector specifying the height and width of the diamonds displaying sample sizes.}

\item{font.size}{a vector specifying the size of labels and text; the first element is for the main titles, the second is for
for the x-axis labels; the thrid is for the text in the first sub-figure; the fourth is for the unit labels of
the x-axis.}

\item{title}{a list of three strings specifying the main titles of the three sub-figures.}

\item{lab.x}{a list of three strings specifying the x-axis labels of the three sub-figures.}

\item{time}{time for calculating the RMST}

\item{KM}{a logical indicating whether to show the Kaplan-Meier curves in the third panel}

\item{show.km.axis}{a logical indicating whether to show the axes in the Kaplan-Meier curves}

\item{widths}{a vector of length 3 indicating the widths of the panels}

\item{max.time}{a numeric input indicating the maximum time for x-axis in the the Kaplan-Meier curves. If NULL, the maximum is taken from the dataset.}

\item{n.brk}{number of breaks in the Kaplan-Meier curves}

\item{trt.labels}{A character vector or length 2 specifying the labels of the treatments}

\item{panel.titles}{A character vector or length 3 specifying the column titles in the first panel}

\item{eff.scale}{Either "logHR" or "HR". Only necessary when outcome.type = "survival".}
}
\description{
This function produces a forest plot showing the treatment effect size of subgroups defined by the categories of covariates. The
first sub-figure provides a table of treatment effect estimate and sample size (for treatment / control group within each subgroup)
; the second sub-figure shows forest plots for subgroups and full population; the third displays forest plots of treatment and
control group for each population. The dashed vertical line indicates no effect Note that the overall size of diamonds which
represent subgroups can be adjusted by setting different values on the associated input argument. In addition, the function uses
log odd ratio and log hazard ratio for displaying subgroup effect sizes in binary and survival data, respectively.
}
\examples{
# Load the data to be used
library(dplyr)
data(prca)
dat <- prca
dat \%>\%
  mutate(bm = factor(ifelse(bm == 0 , "No", "Yes")),
         hx = factor(ifelse(hx == 0 , "No", "Yes"))) -> dat

## 5. Forest Plot -----------------------------------------------------------
main.title = list("", "Forest plot of subgroups",
                  "Kaplan-Meier curves\n by treatment group")
label.x = list("", "Log hazard ratio",
               "Time (days)")

plot_forest(dat,
            covari.sel = c(4,5,6,7),#vars
            trt.sel = 3,
            resp.sel = c(1, 2),
            outcome.type = "survival",
            size.shape = c(0.3, 6.5/4),
            font.size = c(0.6, 0.5, 0.4, 0.6),
            title = main.title,
            lab.x = label.x, time = 50, KM = TRUE,
            show.km.axis = 2, n.brk = 12, max.time = 77,
            widths = c(1,1,0.6))

}
