% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/26-circular-plot-function.r
\name{plot_circle}
\alias{plot_circle}
\title{Circular plot using circlize package}
\usage{
plot_circle(dat, covari.sel, trt.sel, resp.sel, outcome.type, range.v = NULL,
  adj.ann.subgrp = 4, range.strip = c(-3, 3), n.brk = 31,
  n.brk.axis = NULL, font.size = c(1, 1, 0.85, 0.85, 1), title = NULL,
  lab.xy = NULL, strip = "Treatment effect size", effect = "HR",
  equal.width = TRUE, show.KM = FALSE, show.effect = TRUE,
  conf.int = TRUE, show.overall = TRUE, palette = "divergent",
  col.power = 0.5)
}
\arguments{
\item{dat}{a data set}

\item{covari.sel}{a vector of indices of the two covariates}

\item{trt.sel}{a covariate index specifying the treatment code}

\item{resp.sel}{a covariate index specifying the response variable}

\item{outcome.type}{a string specifying the type of the response variable, it can be "continuous", or "binary" or  "survival".}

\item{range.v}{a vector specifying the vertical range of graphical display.}

\item{adj.ann.subgrp}{a parameter adjusting the distance between a point and its corresponding subgroup label. The smaller the value
is, the larger the distance is.}

\item{range.strip}{a vector with two elements specifying the range of treatment effect size for display}

\item{n.brk}{a number specifying the number of the points dividing the range of the argument "range.strip".}

\item{n.brk.axis}{a number specifying the number of breakpoints dividing the axis of the argument "range.strip".}

\item{font.size}{a vector specifying the size of labels and text; the first element is for the main title, the second is for
for x-axis and y-axis labels; the thrid is for the legend text of subgroups; the fourth is for the subgroup
labels near points; the fifth is for the unit labels on all the axes.}

\item{title}{a string specifying the main title.}

\item{lab.xy}{a list of two strings specifying the labels of the x and y axes.}

\item{strip}{a string specifying the title of the colour strip.}

\item{effect}{either "HR" or "RMST". only when outcome.type = "survival"}

\item{equal.width}{A logical indicating whether the sectors should have equal width or proportional to their sample sizes}

\item{show.KM}{A logical indicating whether to show the Kaplan-Meier curves for the subgroups}

\item{show.effect}{A logical indicating whether to show the treatment effect}

\item{conf.int}{A logical indicating whether to show confidence intervals for the treatment effect.}

\item{show.overall}{A logical indicating whether to show the overall treatment effect and its confidence intervals in the reference strip}

\item{palette}{either "divergent" or "hcl"}

\item{col.power}{to be used when palette = "hcl". see colorspace package for reference}
}
\description{
This function produces a circular plot for subgroup analysis
}
\examples{
library(dplyr)

# Load the data to be used
data(prca)
dat <- prca
vars = data.frame(variable = names(dat), index = 1:length(names(dat)))
levels(dat$age_group) = c("Young","Middle-aged","Old")
levels(dat$weight_group)  = c("Low","Mid","High")
dat \%>\%
  rename(Age= age_group,
         Weight = weight_group)-> dat

set.seed(55643)
plot_circle(dat,
            covari.sel = c(14, 15),
            trt.sel = 3,
            resp.sel = c(1, 2),
            outcome.type = "survival",
            range.v = NULL, adj.ann.subgrp = 4,
            range.strip=c(-3, 3),
            n.brk = 31,
            n.brk.axis = 7,
            font.size = c(1, 1, 0.85, 0.85, 1),
            title = NULL, lab.xy = NULL,
            strip = "Treatment effect size (log hazard ratio)",
            effect = "HR",
            equal.width = FALSE,
            show.KM = FALSE,
            show.effect = TRUE,
            conf.int = FALSE, palette = "hcl")

}

