% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GETESS.R
\name{GetESS}
\alias{GetESS}
\title{Determines Prior ESS for fixed values of sigma_alpha^2 and sigmabeta^2}
\usage{
GetESS(Dose, meanmu, meanslope, MeanInts, MeanSlopes, varint, varbeta)
}
\arguments{
\item{Dose}{Vector containing standardized doses.}

\item{meanmu}{Prior mean for baseline intercept.}

\item{meanslope}{Prior mean for baseline slope.}

\item{MeanInts}{Vector of prior means for the group specific intercept parameters.}

\item{MeanSlopes}{Vector of prior means for the group specific slope parameters.}

\item{varint}{Prior variance for the intercept parameters.}

\item{varbeta}{Prior variance for the slope parameters.}
}
\value{
Returns the nonlinear regression model whos parameter estimates will be used as prior means for the SubTITE Design.
}
\description{
Uses the prior means for the intercept and slope parameters and the number of doses to obtain an approximate prior ESS for the given prior variances. The user should calibrate varint and varbeta with varint>varbeta such that the ESS value is 1.
}
\examples{
###Specify the prior hypermeans
meanmu=-.5
meanslope=-.05
MeanInts = c(-.5,-.1)
MeanSlopes = c(.1,0)
Dose=sort(rnorm(5))
varint=5
varbeta=1
GetESS(Dose,meanmu,meanslope,MeanInts,MeanSlopes,varint,varbeta)
}
\references{
[1] Chapple and Thall (2017), Subgroup-specific dose finding in phase I clinical trials based on time to toxicity allowing adaptive subgroup combination.
}
