% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdfDisplay.R
\name{pdfDisplay}
\alias{pdfDisplay}
\title{Generates PDF and SVG figures}
\usage{
pdfDisplay(g, width, height, name, ext = ".pdf", dir = getwd(),
  openfile = FALSE, pargs = list(), output = F, warn = T)
}
\arguments{
\item{g}{the plot function to be exported and looked at}

\item{width}{the width of the drawing area (in inches)}

\item{height}{the height of the drawing area (in inches)}

\item{name}{the name of the document}

\item{ext}{the extension of the document: ".pdf" by default, but
".svg" works also.}

\item{dir}{the file where the document will be saved (by default the
working directory, getwd())}

\item{openfile}{should the pdf file be opened (for the moment works
only in Windows). Use SumatraPDF as default pdf reader to be able to write
over current file}

\item{pargs}{list of arguments transmitted to the par() function}

\item{output}{whether to output the output of g() or not}

\item{warn}{whether you want to be annoyed by the \code{openfile}
warning}
}
\value{
the output of the g() function if output = TRUE
}
\description{
Takes an ensemble of figures, represented by a function g(), and
generates a PDF (or SVG if specified). The PDF can be visualised immediatly
on the default PDF reader, preferentially one that can be refreshed without
closing it (e.g. SumatraPDF, but it only works in Windows).
}
\details{
This a fragile function, I believe it is especially sensible to OS
changes. The openfile argument will only work in Windows (I'm not even sure
it will work in all Windows versions).

Also the width and height you provide will not exactly be respected. I could
not find a pdf printing function that respects dimensions scrupulously for
R base graphics.
}
\examples{
g1   <- function() plot(1,1)

temp <- tempfile()
dir.create(temp)

pdfDisplay(g1(),8.27,11.69,
           "TestGraph", dir = temp, openfile = TRUE,
           pargs = list(mar = c(6,6,6,6), ps = 24,lwd = 4))

}
