% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply_niche.R
\name{apply_niche}
\alias{apply_niche}
\title{apply niche model to events}
\usage{
apply_niche(x, niche_def, gc)
}
\arguments{
\item{x}{events, e.g. times/ages of fossil occurrences or their stratigraphic position.}

\item{niche_def}{function, specifying the niche along a gradient. Should return 0 when taxon is outside of niche, and 1 when inside niche. Values between 0 and 1 are interpreted as collection probabilities.}

\item{gc}{function, stands for "gradient change". Specifies how the gradient changes, e.g. with time}
}
\value{
numeric vector, timing/location of events (e.g. fossil ages/locations) preserved after the niche model is applied
}
\description{
Models niches by removing events (fossil occurrences) when they are outside of their niche using the function \code{thin}.
Combines the functions \code{niche_def} and \code{gc} ("gradient change") to determine how the taxons' collection probability changes with time/position. This is done by composing \code{niche_def} and \code{gc}. The result is then used as a thinning on the events \code{x}.
}
\examples{

## setup
# using water depth as gradient
 t = scenarioA$t_myr
 wd = scenarioA$wd_m[,"8km"]
 gc = approxfun(t, wd)
 plot(t, gc(t), type = "l", xlab = "Time", ylab = "water depth [m]",
  main = "gradient change with time")
 # define niche
 # preferred wd 10 m, tolerant to intermediate wd changes (standard deviation 10 m), non-terrestrial
 niche_def = snd_niche(opt = 10, tol = 10, cutoff_val = 0)
 plot(seq(-1, 50, by = 0.5), niche_def(seq(-1, 50, by = 0.5)), type = "l",
 xlab = "water depth", ylab = "collection probability", main = "Niche def")
 # niche pref with time
 plot(t, niche_def(gc(t)), type = "l", xlab = "time",
 ylab = "collection probability", main = "collection probability with time")

 ## simulate fossil occurrences
 foss_occ = p3(rate = 100, from = 0, to = max(t))
 # foss occ without niche pref
 hist(foss_occ, xlab = "time")
 foss_occ_niche = apply_niche(foss_occ, niche_def, gc)
 # fossil occurrences with niche preference
 hist(foss_occ_niche, xlab = "time")

 # see also
 #vignette("event_data")
 # for a detailed example on niche modeling



}
\seealso{
\code{\link[=apply_taphonomy]{apply_taphonomy()}} to model taphonomic effects based on the same principle, \code{\link[=thin]{thin()}} for the underlying mathematical procedure. Basic niche models available are \code{\link[=bounded_niche]{bounded_niche()}} and \code{\link[=snd_niche]{snd_niche()}}
}
