% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defStormsList.R
\docType{methods}
\name{getStorm}
\alias{getStorm}
\alias{getStorm,stormsList-method}
\title{Extracting a \code{storm}}
\usage{
getStorm(sts, name, season = NULL)

\S4method{getStorm}{stormsList}(sts, name, season = NULL)
}
\arguments{
\item{sts}{\code{stormsList}}

\item{name}{character. Name of the storm to extract.}

\item{season}{numeric vector. Seasons of occurrence of the storms
(e.g., c(2020,2022)). In the Southern Hemisphere,
the cyclone season extends across two consecutive years.
Therefore, to capture the 2021 to 2022 cyclone season both
years should be specified, with cyclones assigned for the year
#'  that originated in. By default all storms occurring since
1980 are extracted.}
}
\value{
A \code{storm} object.
}
\description{
The \code{getStorm()} function extracts a specific \code{storm} object
from a \code{stormsList} object.
}
\examples{
#Creating a stormsDataset
\donttest{
sds <- defStormsDataset()

#Getting storm track data for all storms near New Caledonia
sts <- defStormsList(sds=sds, loi = "New Caledonia")

#Getting `storm` for the tropical cyclone Niran
st <- getStorm(sts, name = "NIRAN")
}
}
