% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defStormsList.R
\docType{methods}
\name{getInObs}
\alias{getInObs}
\alias{getInObs,stormsList-method}
\alias{getInObs,storm-method}
\title{Getting the number of the observations}
\usage{
getInObs(s, ...)

\S4method{getInObs}{stormsList}(s, name, season = NULL)

\S4method{getInObs}{storm}(s)
}
\arguments{
\item{s}{\code{storm} or \code{stormsList} object.}

\item{...}{extra argument for \code{stormsList}}

\item{name}{character. Name of the storm in capital letters.}

\item{season}{numeric. Cyclonic season of the \code{storm}. Required only
if several \code{storm} in \code{s} object have the same name. Default value is set
to \code{NULL}}
}
\value{
Numeric vector.
}
\description{
The \code{getInObs()} function returns the number of the
observations in a given \code{storm} or \code{stormsList} object.
}
\examples{
#Creating a stormsDataset
\donttest{
sds <- defStormsDataset()

#Getting storm track data for all storms near New Caledonia
sts <- defStormsList(sds=sds, loi = "New Caledonia")

#Getting the number of the observation for the tropical cyclone Niran in the sts object
getInObs(getStorm(sts, name = "NIRAN"))
getInObs(sts, name = "NIRAN")
}
}
