% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_fitting_functions.R
\name{fit.models}
\alias{fit.models}
\title{Fit all models to data}
\usage{
fit.models(data, d.range, d.adj.max = 1.1, wts = c(2, 1))
}
\arguments{
\item{data}{(Required). A list containing fitness values for allele combinations.
See examples in \code{data} or in the vignette.}

\item{d.range}{(Required). Range of realistic fitness changes from WT. "d" is the
difference between maximal fitness and WT fitness. For example, WT fitness for the
virus phix174 is about 20, but values up to about 25 have been observed, so d.range was set to:
d.range <- c(0.1,10).}

\item{d.adj.max}{(Optional). Default 1.1. When the estimation of d fails in
\code{\link{estimate.d.MLE}}, \code{\link{estimate.d.RDB}}, or \code{\link{estimate.d.sequential}} then d becomes 1.1*WT fitness so that models can be fit.}

\item{wts}{(Optional). Default c(2,1).}
}
\value{
List:\cr
 [[1]] \code{fit.smry} contains the R^2 and P values for all models
  coefficients \cr
 [[2]] \code{fit.stick} contains stickbreaking model details like the intercept, slope, and predicted fitness values for the given allele combinations.\cr
 [[2]] \code{fit.mult} contains multiplicative model details like the intercept, slope, and predicted fitness values for the given allele combinations.\cr
 [[2]] \code{fit.stick} contains additive model details like the intercept, slope, and predicted fitness values for the given allele combinations.\cr
}
\description{
Fit all models using \code{fit.models}. Used as a wrapper to combine outputs from \code{\link{estimate.d.MLE}}, \code{\link{estimate.d.RDB}}, \code{\link{estimate.d.sequential}}, \code{\link{fit.stick.model.given.d}}, \code{\link{fit.mult.model}}, \code{\link{fit.add.model}}, and \code{\link{summarize.fits.for.posterior.calc}}.
}
\details{
Function is a wrapper that fits the data to all three models. First, it estimates $d$ and, using this estimate, fits the stickbreaking model. Then it fits the multiplicative and additive models.
}
\examples{
fit.models(Chou.data, d.range=c(0.1, 10), d.adj.max=1.1, wts=c(2,1))
}
\seealso{
\code{\link{estimate.d.MLE}}, \code{\link{estimate.d.RDB}}, \code{\link{estimate.d.sequential}}, \code{\link{fit.stick.model.given.d}}, \code{\link{fit.mult.model}}, \code{\link{fit.add.model}}, \code{\link{summarize.fits.for.posterior.calc}}, \code{\link{estimate.d.MLE}}, \code{\link{estimate.d.RDB}}, \code{\link{estimate.d.sequential}}
}

