/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.sql;

import java.util.List;
import org.ohdsi.sql.SqlTranslate;
import org.ohdsi.sql.StringUtils;

public class BigQueryTranslate {
    private static String bigQueryAliasCommonTableExpressions(String sql, String pattern, String prefix) {
        List<SqlTranslate.Block> cte_pattern = SqlTranslate.parseSearchPattern(pattern);
        SqlTranslate.MatchedPattern cte_match = SqlTranslate.search(sql, cte_pattern, 0);
        while (cte_match.start != -1) {
            CommaListIterator with_list_iter = new CommaListIterator(cte_match.variableToValue.get("@@b"), CommaListIterator.ListType.WITH_COLUMNS);
            CommaListIterator select_list_iter = new CommaListIterator(cte_match.variableToValue.get("@@c"), CommaListIterator.ListType.SELECT);
            String replacement_select_list = "";
            while (!with_list_iter.IsDone() && !select_list_iter.IsDone()) {
                String with_expr = with_list_iter.GetFullExpression();
                String select_expr = select_list_iter.GetExpressionPrefix() + " as " + with_expr;
                replacement_select_list = replacement_select_list + "," + select_expr;
                with_list_iter.Next();
                select_list_iter.Next();
            }
            replacement_select_list = select_list_iter.GetListPrefix() + replacement_select_list + select_list_iter.GetListSuffix();
            sql = sql.substring(0, cte_match.start) + prefix + cte_match.variableToValue.get("@@a") + " as (select " + replacement_select_list.substring(1) + " from " + cte_match.variableToValue.get("@@d") + ")" + sql.substring(cte_match.end);
            cte_match = SqlTranslate.search(sql, cte_pattern, cte_match.startToken + 1);
        }
        return sql;
    }

    private static String bigQueryConvertSelectListReferences(String sql, String select_pattern, CommaListIterator.ListType list_type) {
        sql = sql + ";";
        List<SqlTranslate.Block> select_statement_pattern = SqlTranslate.parseSearchPattern(select_pattern);
        SqlTranslate.MatchedPattern select_statement_match = SqlTranslate.search(sql, select_statement_pattern, 0);
        while (select_statement_match.start != -1) {
            String select_list = select_statement_match.variableToValue.get("@@s");
            String list_to_replace = select_statement_match.variableToValue.get("@@r");
            String replacement_list = "";
            CommaListIterator list_to_replace_iter = new CommaListIterator(list_to_replace, list_type);
            while (!list_to_replace_iter.IsDone()) {
                String list_expr = list_to_replace_iter.GetExpressionPrefix();
                String list_expr_suffix = list_to_replace_iter.GetExpressionSuffix();
                List<SqlTranslate.Block> list_expr_pattern = SqlTranslate.parseSearchPattern(list_expr);
                if (list_to_replace_iter.IsSingleColumnReference()) {
                    replacement_list = replacement_list + ", " + list_expr + list_expr_suffix;
                } else {
                    CommaListIterator select_list_iter = new CommaListIterator(select_list, CommaListIterator.ListType.SELECT);
                    boolean found = false;
                    int i = 1;
                    while (!select_list_iter.IsDone()) {
                        String select_expr = select_list_iter.GetExpressionPrefix();
                        if (SqlTranslate.search((String)select_expr, list_expr_pattern, (int)0).start != -1) {
                            found = true;
                            replacement_list = replacement_list + ", " + i + list_expr_suffix;
                            break;
                        }
                        ++i;
                        select_list_iter.Next();
                    }
                    if (!found) {
                        replacement_list = replacement_list + ", " + list_expr + list_expr_suffix;
                    }
                }
                list_to_replace_iter.Next();
            }
            replacement_list = list_to_replace_iter.GetListPrefix() + replacement_list.substring(1) + list_to_replace_iter.GetListSuffix();
            String suffix = sql.substring(select_statement_match.end);
            sql = sql.substring(0, select_statement_match.start);
            for (int i = 0; i < select_statement_pattern.size(); ++i) {
                if (sql.length() > 0) {
                    sql = sql + " ";
                }
                SqlTranslate.Block block = select_statement_pattern.get(i);
                if (block.isVariable) {
                    if (block.text.equals("@@r")) {
                        sql = sql + replacement_list;
                        continue;
                    }
                    sql = sql + select_statement_match.variableToValue.get(block.text);
                    continue;
                }
                sql = sql + block.text;
            }
            sql = sql + suffix;
            select_statement_match = SqlTranslate.search(sql, select_statement_pattern, select_statement_match.startToken + 1);
        }
        sql = sql.substring(0, sql.length() - 1);
        return sql;
    }

    private static boolean bigQueryExprIsStringConcat(String select_expr) {
        String[] concat_exprs = new String[]{"^ '@@a' +", "^ cast(@@a as varchar) +", "^ isnull(@@a, '@@b') +", "^ case @@a then '@@b' @@c end +", "^ @@a + '@@b'"};
        for (int i = 0; i < concat_exprs.length; ++i) {
            SqlTranslate.MatchedPattern concat_match = SqlTranslate.search("^" + select_expr, SqlTranslate.parseSearchPattern(concat_exprs[i]), 0);
            if (concat_match.start == -1) continue;
            return true;
        }
        return false;
    }

    private static String bigQueryReplaceStringConcatsInExpr(String select_expr) {
        select_expr = "+" + select_expr + "+";
        List<SqlTranslate.Block> concat_pattern = SqlTranslate.parseSearchPattern("+ @@a + @@b +");
        while (true) {
            SqlTranslate.MatchedPattern concat_match = SqlTranslate.search(select_expr, concat_pattern, 0);
            if (concat_match.start == -1) break;
            String suffix = "";
            if (concat_match.end < select_expr.length()) {
                suffix = select_expr.substring(concat_match.end + 1);
            }
            select_expr = "+concat(" + concat_match.variableToValue.get("@@a") + ", " + concat_match.variableToValue.get("@@b") + ")+" + suffix;
        }
        return select_expr.substring(1, select_expr.length() - 1);
    }

    private static String bigQueryReplaceStringConcatsInStatement(String sql) {
        List<SqlTranslate.Block> select_statement_pattern = SqlTranslate.parseSearchPattern("select @@a from");
        SqlTranslate.MatchedPattern select_statement_match = SqlTranslate.search(sql, select_statement_pattern, 0);
        while (select_statement_match.start != -1) {
            String select_list = select_statement_match.variableToValue.get("@@a");
            String replacement_select_list = "";
            CommaListIterator select_list_iter = new CommaListIterator(select_list, CommaListIterator.ListType.SELECT);
            while (!select_list_iter.IsDone()) {
                String replacement_select_expr = select_list_iter.GetExpressionPrefix();
                if (BigQueryTranslate.bigQueryExprIsStringConcat(replacement_select_expr)) {
                    replacement_select_expr = BigQueryTranslate.bigQueryReplaceStringConcatsInExpr(replacement_select_expr);
                }
                replacement_select_list = replacement_select_list + ", " + replacement_select_expr;
                String alias = select_list_iter.GetExpressionSuffix();
                if (alias.length() > 0) {
                    replacement_select_list = replacement_select_list + "as " + alias;
                }
                select_list_iter.Next();
            }
            replacement_select_list = select_list_iter.GetListPrefix() + replacement_select_list.substring(1) + select_list_iter.GetListSuffix();
            sql = sql.substring(0, select_statement_match.start) + "select " + replacement_select_list + " from " + sql.substring(select_statement_match.end, sql.length());
            select_statement_match = SqlTranslate.search(sql, select_statement_pattern, select_statement_match.startToken + 1);
        }
        return sql;
    }

    private static String bigQueryLowerCase(String sql) {
        List<StringUtils.Token> tokens = StringUtils.tokenizeSql(sql);
        for (StringUtils.Token token : tokens) {
            if (token.inQuotes) continue;
            sql = sql.substring(0, token.start) + token.text.toLowerCase() + sql.substring(token.end);
        }
        return sql;
    }

    private static String bigQueryUnquoteIdInLists(String sql) {
        List<SqlTranslate.Block> in_list_pattern = SqlTranslate.parseSearchPattern("in (@@i)");
        List<StringUtils.Token> tokens = StringUtils.tokenizeSql(sql);
        SqlTranslate.MatchedPattern in_list_match = SqlTranslate.search(sql, in_list_pattern, 0);
        while (in_list_match.start != -1) {
            StringUtils.Token lhs_token;
            String in_list = in_list_match.variableToValue.get("@@i");
            if (in_list_match.startToken > 0 && (lhs_token = tokens.get(in_list_match.startToken - 1)).isIdentifier() && lhs_token.text.toLowerCase().endsWith("_id")) {
                CommaListIterator in_list_iter = new CommaListIterator(in_list, CommaListIterator.ListType.IN);
                while (!in_list_iter.IsDone()) {
                    String expr = in_list_iter.GetFullExpression();
                    if (expr.charAt(0) != '\'' || expr.charAt(expr.length() - 1) != '\'') {
                        return sql;
                    }
                    for (int i = 1; i < expr.length() - 1; ++i) {
                        if (Character.isDigit(expr.charAt(i))) continue;
                        return sql;
                    }
                    in_list_iter.Next();
                }
                String replacement_in_list = in_list.replaceAll("'", "");
                sql = sql.substring(0, in_list_match.start) + " in (" + replacement_in_list + ")" + sql.substring(in_list_match.end, sql.length());
            }
            in_list_match = SqlTranslate.search(sql, in_list_pattern, in_list_match.startToken + 1);
        }
        return sql;
    }

    public static String translatebigQuery(String sql) {
        sql = BigQueryTranslate.bigQueryLowerCase(sql);
        sql = BigQueryTranslate.bigQueryAliasCommonTableExpressions(sql, "with @@a (@@b) as (select @@c from @@d)", "with ");
        sql = BigQueryTranslate.bigQueryAliasCommonTableExpressions(sql, ", @@a (@@b) as (select @@c from @@d)", ", ");
        sql = BigQueryTranslate.bigQueryConvertSelectListReferences(sql, "select @@s from @@b group by @@r;", CommaListIterator.ListType.GROUP_BY);
        sql = BigQueryTranslate.bigQueryConvertSelectListReferences(sql, "select @@s from @@b group by @@r)", CommaListIterator.ListType.GROUP_BY);
        sql = BigQueryTranslate.bigQueryConvertSelectListReferences(sql, "select @@s from @@b group by @@c order by @@r;", CommaListIterator.ListType.ORDER_BY);
        sql = BigQueryTranslate.bigQueryReplaceStringConcatsInStatement(sql);
        sql = BigQueryTranslate.bigQueryUnquoteIdInLists(sql);
        return sql;
    }

    private static class CommaListIterator {
        private String expressionList;
        private List<SqlTranslate.Block> listElementPattern;
        private SqlTranslate.MatchedPattern currentMatch;
        private ListType listType;
        private String expressionPrefix;
        private String expressionSuffix;
        private String listPrefix;
        private String listSuffix;

        public CommaListIterator(String expression_list, ListType list_type) {
            this.listType = list_type;
            this.expressionList = expression_list;
            this.splitList();
            this.expressionList = "," + this.expressionList + ",";
            this.listElementPattern = SqlTranslate.parseSearchPattern(", @@a ,");
            this.currentMatch = SqlTranslate.search(this.expressionList, this.listElementPattern, 0);
            if (this.currentMatch.start != -1) {
                this.splitExpression();
            }
        }

        public boolean IsDone() {
            return this.currentMatch.start == -1;
        }

        public void Next() {
            int expr_length = StringUtils.tokenizeSql(this.expressionList.substring(this.currentMatch.start, this.currentMatch.end)).size();
            int startToken = this.currentMatch.startToken + expr_length - 1;
            this.currentMatch = SqlTranslate.search(this.expressionList, this.listElementPattern, startToken);
            if (this.currentMatch.start != -1) {
                this.splitExpression();
            }
        }

        public String GetExpressionPrefix() {
            return this.expressionPrefix;
        }

        public String GetExpressionSuffix() {
            return this.expressionSuffix;
        }

        public String GetFullExpression() {
            return this.expressionPrefix + this.expressionSuffix;
        }

        public String GetListPrefix() {
            return this.listPrefix;
        }

        public String GetListSuffix() {
            return this.listSuffix;
        }

        private void splitList() {
            this.listPrefix = "";
            this.listSuffix = "";
            switch (this.listType) {
                case SELECT: {
                    this.splitSelect();
                    break;
                }
                case GROUP_BY: {
                    this.splitGroupBy();
                    break;
                }
                case ORDER_BY: {
                    break;
                }
                case WITH_COLUMNS: {
                    break;
                }
            }
        }

        private void splitSelect() {
            SqlTranslate.MatchedPattern match = SqlTranslate.search("^" + this.expressionList + "$", SqlTranslate.parseSearchPattern("^ distinct @@a $"), 0);
            if (match.start != -1) {
                this.listPrefix = "distinct ";
                this.expressionList = match.variableToValue.get("@@a");
            }
            match = SqlTranslate.search("^" + this.expressionList + "$", SqlTranslate.parseSearchPattern("^@@a into @@b$"), 0);
            if (match.start != -1) {
                this.expressionList = match.variableToValue.get("@@a");
                this.listSuffix = " into " + match.variableToValue.get("@@b");
            }
        }

        private void splitGroupBy() {
            SqlTranslate.MatchedPattern match = SqlTranslate.search("^" + this.expressionList + "$", SqlTranslate.parseSearchPattern("^@@a order by @@b$"), 0);
            if (match.start != -1) {
                this.expressionList = match.variableToValue.get("@@a");
                this.listSuffix = " order by " + match.variableToValue.get("@@b");
            }
        }

        private void splitExpression() {
            this.expressionPrefix = this.currentMatch.variableToValue.get("@@a");
            this.expressionSuffix = "";
            switch (this.listType) {
                case SELECT: {
                    this.splitAlias();
                    break;
                }
                case GROUP_BY: {
                    break;
                }
                case ORDER_BY: {
                    this.splitOrderElement();
                    break;
                }
                case WITH_COLUMNS: {
                    break;
                }
            }
        }

        private void splitAlias() {
            List<StringUtils.Token> tokens = StringUtils.tokenizeSql(this.expressionPrefix);
            List<SqlTranslate.Block> alias_pattern = SqlTranslate.parseSearchPattern("^ @@a as @@b $");
            SqlTranslate.MatchedPattern alias_match = SqlTranslate.search("^" + this.expressionPrefix + "$", alias_pattern, 0);
            if (alias_match.start == -1) {
                if (tokens.size() >= 2) {
                    StringUtils.Token possible_alias = tokens.get(tokens.size() - 1);
                    String preceding_token = tokens.get((int)(tokens.size() - 2)).text;
                    if (possible_alias.isIdentifier() && !preceding_token.equalsIgnoreCase(".") && !preceding_token.equalsIgnoreCase("+")) {
                        this.expressionPrefix = this.expressionPrefix.substring(0, possible_alias.start);
                        this.expressionSuffix = possible_alias.text;
                    }
                }
            } else {
                this.expressionPrefix = alias_match.variableToValue.get("@@a");
                this.expressionSuffix = alias_match.variableToValue.get("@@b");
            }
        }

        private void splitOrderElement() {
            List<StringUtils.Token> tokens = StringUtils.tokenizeSql(this.GetFullExpression());
            StringUtils.Token last_token = tokens.get(tokens.size() - 1);
            if (last_token.text.equalsIgnoreCase("asc") || last_token.text.equalsIgnoreCase("desc")) {
                this.expressionPrefix = this.GetFullExpression().substring(0, last_token.start - 1);
                this.expressionSuffix = " " + last_token.text;
            }
        }

        public boolean IsSingleColumnReference() {
            List<StringUtils.Token> tokens = StringUtils.tokenizeSql(this.GetExpressionPrefix());
            return tokens.size() == 3 && tokens.get(0).isIdentifier() && tokens.get((int)1).text.contentEquals(".") && tokens.get(2).isIdentifier();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum ListType {
            SELECT,
            GROUP_BY,
            ORDER_BY,
            WITH_COLUMNS,
            IN;

        }
    }
}

