% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EnsCrps.R
\name{EnsCrps}
\alias{EnsCrps}
\alias{FairCrps}
\title{Calculate the ensemble-adjusted Continuous Ranked Probability Score (CRPS)}
\usage{
EnsCrps(ens, obs, R.new = NA)

FairCrps(ens, obs)
}
\arguments{
\item{ens}{a N*R matrix representing N time instances of real-valued R-member ensemble forecasts}

\item{obs}{a numeric vector of length N with real-valued observations}

\item{R.new}{positive number, can be `Inf`, ensemble size for which the scores should be adjusted, default is NA for no adjustment}
}
\value{
numeric vector of length N with the ensemble-adjusted CRPS values
}
\description{
Calculate the ensemble-adjusted Continuous Ranked Probability Score (CRPS)
}
\details{
`FairCrps(ens, obs)` returns `EnsCrps(ens, obs, R.new=Inf)`
}
\examples{
data(eurotempforecast)
mean(EnsCrps(ens, obs, R.new=Inf))
}
\references{
Ferro CAT, Richardson SR, Weigel AP (2008) On the effect of ensemble size on the discrete and continuous ranked probability scores. Meteorological Applications. \doi{10.1002/met.45}
}
\seealso{
EnsBrier, EnsRps, DressCrps, GaussCrps, ScoreDiff, SkillScore
}
