% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lyme.svs.eco0.dat.R
\docType{data}
\name{lyme.svs.eco0.dat}
\alias{lyme.svs.eco0.dat}
\title{The Lyme disease dataset with Eco id=0}
\format{\describe{
  \item{\code{y}}{integer vector, output count, each element represents the disease count in one census tract.}
  \item{\code{X}}{Numeric matrix, matrix of covariates, includes percentage of developed land in each census tract, percentage of forest in each census tract, etc.}
  \item{\code{offset}}{Numeric vector, vector for offset values, each element represents the log of population divided by 20,000 in census tract.}
  \item{\code{location}}{Numeric matrix, location for each census tract.}
}}
\usage{
lyme.svs.eco0.dat
}
\description{
The Lyme disease dataset contains case data from 2006 to 2011 demographic
data and land cover data in Virginia. Lyme disease case data were collected by Virginia Department of Health.
Eco id = 0 represents northern/western subregion, which includes Northern Piedmont, Blue Ridge, Ridge and Valley, and Central Appalachian.
}

\references{
Xie, Y., Xu, L., Li, J., Deng, X., Hong, Y., Kolivras, K., and Gaines, D. N. (2018). Spatial Variable Selection and An Application to Virginia Lyme Disease Emergence. Preprint, arXiv:1809.06418 [stat.AP].
}

\examples{
data("lyme.svs.eco0")
#example for computing the distance matrix and add it to the data object.
library(fields)
tmp.dist=rdist.earth(lyme.svs.eco0.dat$location, miles=FALSE, R=6371)
#manual fix those distannces are to close to zero, which might cause
#problems in parameter estimation.
tmp.dist[tmp.dist<0.4712249]=0.4712249
diag(tmp.dist)=0
lyme.svs.eco0.dat$dist=tmp.dist

}
\keyword{datasets}
