% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stewart.R
\name{stewart}
\alias{stewart}
\title{Stewart Potentials}
\usage{
stewart(knownpts, unknownpts = NULL, matdist = NULL, varname,
  typefct = "exponential", span, beta, resolution = NULL, mask = NULL)
}
\arguments{
\item{knownpts}{sp object (SpatialPointsDataFrame or SpatialPolygonsDataFrame);
this is the set of known observations to estimate the potentials from.}

\item{unknownpts}{sp object (SpatialPointsDataFrame or SpatialPolygonsDataFrame); 
this is the set of unknown units for which the function computes the estimates. 
Not used when \code{resolution} is set up. (optional)}

\item{matdist}{matrix; distance matrix between known observations and unknown 
units for which the function computes the estimates. Row names match the row 
names of \code{knownpts} and column names match the row names of 
\code{unknownpts}. \code{matdist} can contain any distance metric (time 
distance or euclidean distance for example). If \code{matdist} is NULL, Great 
Circle distances are used (with \code{\link{CreateDistMatrix}}).(optional)}

\item{varname}{character; name of the variable in the \code{knownpts} dataframe 
from which potentials are computed. Quantitative variable with no negative values.}

\item{typefct}{character; spatial interaction function. Options are "pareto" 
(means power law) or "exponential".
If "pareto" the interaction is defined as: (1 + alpha * mDistance) ^ (-beta).
If "exponential" the interaction is defined as: 
exp(- alpha * mDistance ^ beta).
The alpha parameter is computed from parameters given by the user 
(\code{beta} and \code{span}).}

\item{span}{numeric; distance where the density of probability of the spatial 
interaction function equals 0.5.}

\item{beta}{numeric; impedance factor for the spatial interaction function.}

\item{resolution}{numeric; resolution of the output SpatialPointsDataFrame
(in map units).}

\item{mask}{sp object; the spatial extent of this object is used to 
create the regularly spaced SpatialPointsDataFrame output. (optional)}
}
\value{
SpatialPointsDataFrame with the computed potentials in a new field 
named \code{OUTPUT}
}
\description{
This function computes the potentials as defined by J.Q. Stewart (1942).
}
\examples{
# Create a SpatialPointsDataFrame grid of spatMask extent and 200 meters 
# resolution
data(spatData)
mygrid <- CreateGrid(w = spatMask, resolution = 200)
# Create a distance matrix between known points (spatPts) and mygrid
mymat <- CreateDistMatrix(knownpts = spatPts, unknownpts = mygrid)
# Compute Stewart potentials from known points (spatPts) on a given 
# grid (mygrid) using a given distance matrix (mymat)
mystewart <- stewart(knownpts = spatPts, unknownpts = mygrid, 
                     matdist = mymat, varname = "Capacite", 
                     typefct = "exponential", span = 1250, 
                     beta = 3, mask = spatMask)
# Compute Stewart potentials from known points (spatPts) on a 
# grid defined by its resolution
mystewart2 <- stewart(knownpts = spatPts, varname = "Capacite", 
                      typefct = "exponential", span = 1250, beta = 3, 
                      resolution = 200, mask = spatMask)
# The two methods have the same result
identical(mystewart, mystewart2)
# the function output a SpatialPointsDataFrame
class(mystewart)
# Computed values
summary(mystewart$OUTPUT)
}
\references{
STEWART J.Q. (1942) "Measure of the influence of a population at a distance", Sociometry, 5(1): 63-71.
}
\seealso{
\link{rasterStewart}, \link{plotStewart}, \link{quickStewart},
\link{rasterToContourPoly}, \link{CreateGrid}, \link{CreateDistMatrix}.
}

