% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reilly.R
\name{plotReilly}
\alias{plotReilly}
\title{Plot a Reilly Raster}
\usage{
plotReilly(x, add = FALSE, col = rainbow)
}
\arguments{
\item{x}{raster; output of the \code{\link{rasterReilly}} function.}

\item{add}{logical; if TRUE the raster is added to the current plot, if FALSE 
the raster is displayed in a new plot.}

\item{col}{function; color ramp function, such as \code{\link{colorRampPalette}}.}
}
\description{
This function plots the raster produced by the 
\code{\link{rasterReilly}} function.
}
\details{
Display the raster nicely.
}
\examples{
data(spatData)
row.names(spatPts) <- spatPts$CodHop
# Compute Reilly catchment areas from known points (spatPts) on a
# grid defined by its resolution
myreilly <- reilly(knownpts = spatPts, varname = "Capacite",
                   typefct = "exponential", span = 750, beta = 2,
                   resolution = 100, mask = spatMask)
# Create a raster of reilly values
myreillyraster <- rasterReilly(x = myreilly, mask = spatMask)
# Plot the raster nicely
plotReilly(x = myreillyraster)
}
\seealso{
\link{reilly}, \link{rasterReilly}, \link{plotReilly}, \link{CreateGrid}, 
\link{CreateDistMatrix}.
}

