% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadData.R
\name{loadSTProfiles}
\alias{loadSTProfiles}
\title{Loads spatial transcriptomics data into a SpatialDDLS object}
\usage{
loadSTProfiles(
  object,
  st.data,
  st.spot.ID.column,
  st.gene.ID.column,
  st.min.counts = 0,
  st.min.spots = 0,
  st.n.slides = 3,
  verbose = TRUE
)
}
\arguments{
\item{object}{A \code{\linkS4class{SpatialDDLS}} object.}

\item{st.data}{A \code{\link[SpatialExperiment]{SpatialExperiment}} object
(or a list with several \code{\link[SpatialExperiment]{SpatialExperiment}}
objects) to be deconvoluted.}

\item{st.spot.ID.column}{Name or number of the column in spots metadata
corresponding to spot names in the expression matrix.}

\item{st.gene.ID.column}{Name or number of the column in genes metadata
corresponding to names used for features/genes.}

\item{st.min.counts}{Minimum gene counts to filter (0 by default).}

\item{st.min.spots}{Minimum of spots with more than \code{min.counts} (0 by
default).}

\item{st.n.slides}{Minimum number of slides
(\code{\link[SpatialExperiment]{SpatialExperiment}} objects) in which a
gene has to be expressed in order to keep it. This parameter is applicable
only when multiple \code{\link[SpatialExperiment]{SpatialExperiment}}
objects are provided. Genes not present in at least \code{st.n.slides} will
be discarded. If no filtering is desired, set \code{st.n.slides = 1}.}

\item{verbose}{Show informative messages during execution (\code{TRUE} by
default).}
}
\value{
A \code{\linkS4class{SpatialDDLS}} object with the provided spatial
trainscriptomics data loaded into the \code{spatial.experiments} slot.
}
\description{
This function loads a \code{\link[SpatialExperiment]{SpatialExperiment}}
object (or a list with several
\code{\link[SpatialExperiment]{SpatialExperiment}} objects) into a
\code{\linkS4class{SpatialDDLS}} object.
}
\details{
It is recommended to perform this step when creating the
\code{\linkS4class{SpatialDDLS}} object using the
\code{\link{createSpatialDDLSobject}} function in order to only keep genes
shared between the spatial transcriptomics and the single-cell
transcriptomics data used as reference. In addition, please, make sure the
gene identifiers used the spatial and single-cell transcriptomics data are
consistent.
}
\examples{
\donttest{
set.seed(123)
sce <- SingleCellExperiment::SingleCellExperiment(
  assays = list(
    counts = matrix(
      rpois(100, lambda = 5), nrow = 40, ncol = 30,
      dimnames = list(paste0("Gene", seq(40)), paste0("RHC", seq(30)))
    )
  ),
  colData = data.frame(
    Cell_ID = paste0("RHC", seq(30)),
    Cell_Type = sample(x = paste0("CellType", seq(4)), size = 30,
                       replace = TRUE)
  ),
  rowData = data.frame(
    Gene_ID = paste0("Gene", seq(40))
  )
)
SDDLS <- createSpatialDDLSobject(
  sc.data = sce,
  sc.cell.ID.column = "Cell_ID",
  sc.gene.ID.column = "Gene_ID",
  sc.filt.genes.cluster = FALSE
)

## simulating a SpatialExperiment object
counts <- matrix(rpois(30, lambda = 5), ncol = 6)
rownames(counts) <- paste0("Gene", 1:5)
colnames(counts) <- paste0("Spot", 1:6)
coordinates <- matrix(
  c(1, 2, 3, 1, 2, 3, 1, 2, 3, 1, 2, 3), ncol = 2
)
ste <- SpatialExperiment::SpatialExperiment(
  assays = list(counts = as.matrix(counts)),
  rowData = data.frame(Gene_ID = paste0("Gene", 1:5)),
  colData = data.frame(Cell_ID = paste0("Spot", 1:6)),
  spatialCoords = coordinates
)

## previous SpatialDDLS object
SDDLS <- loadSTProfiles(
  object = SDDLS,
  st.data = ste,
  st.spot.ID.column = "Cell_ID",
  st.gene.ID.column = "Gene_ID"
)
}
  
}
\seealso{
\code{\link{createSpatialDDLSobject}} \code{\link{trainDeconvModel}}
}
