% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/SpatPCA.R
\name{spatpca}
\alias{spatpca}
\title{Regularized PCA for spatial data}
\usage{
spatpca(Y, sx, sy = NULL, K, tau1, tau2, center = FALSE, maxit = 100, thr = 1e-06,
 sx.new = NULL, sy.new = NULL)
}
\arguments{
\item{Y}{Data matrix (\eqn{n \times p}) stores the values at \eqn{p} locations with sample size \eqn{n}.}

\item{sx}{Numeric vector of \eqn{x}-coordinates of grids.}

\item{sy}{Numeric vector of \eqn{y}-coordinates of grids. If NULL, it is a one-dimensional case.}

\item{K}{User-supplied number of eigenfunctions.}

\item{tau1}{User-supplied nonnegative smoothness parameter value.}

\item{tau2}{User-supplied nonnegative sparseness parameter value.}

\item{center}{If TRUE, center the columns of Y. Default is FALSE.}

\item{maxit}{Maximum number of iterations. Default value is \eqn{10^2}.}

\item{thr}{Threshold for convergence. Default value is \eqn{10^{-6}}.}

\item{sx.new}{Numeric vector of new \eqn{x}-coordinates of grids. If NULL, it is sx.}

\item{sy.new}{Numeric vector of new \eqn{y}-coordinates of grids. If NULL, it is sy.}

}
\value{
\item{eigenfn}{Estimated eigenfunctions at locations of sx.new and sy.new.}

\item{sx.new}{Input vector of new \eqn{x}-coordinates, sx.new, used in the procedure.}

\item{sy.new}{Input vector of new \eqn{y}-coordinates, sy.new, used in the procedure.}

\item{tau1}{Input value of smoothness parameter.}

\item{tau2}{Input value of sparseness parameter.}

\item{K}{Input number of eigenfunctions.}
}
\description{
Produce spatial patterns at the locations according to the smoothness parameter tau1 and the sparseness parameter tau2.
}
\details{
An ADMM form of the proposed objective function is written as
\deqn{\min_{\bm{\Phi}} \|\bm{Y}-\bm{Y}\bm{\Phi}\bm{\Phi}'\|^2_F +\tau_1\mbox{tr}(\bm{\Phi}^T\bm{\Omega}\bm{\Phi})+\tau_2\sum_{k=1}^K\sum_{j=1}^p |\phi_{jk}|,}
\eqn{\mbox{subject to $ \bm{\Phi}^T\bm{\Phi}=\bm{I}_K$,}} where \eqn{\bm{Y}} is a data matrix, \eqn{{\bm{\Omega}}} is a smoothness matrix, and \eqn{\bm{\Phi}=\{\phi_{jk}\}}.
}
\examples{
\dontrun{
s.1D <- as.matrix(seq(-5, 5, length = 50))
Phi.true.1D <- exp(-s.1D^2)/norm(exp(-s.1D^2), "F")
Y.1D <- rnorm(n = 100, sd = 3)\%*\%t(Phi.true.1D) + matrix(rnorm(n = 100*50), 100, 50)
Phi.est <- spatpca(Y = Y.1D, sx = s.1D, K = 1, tau1 = 10, tau2 = 10)
plot(Phi.est)}}
\author{
Wen-Ting Wang and Hsin-Cheng Huang
}
\references{
Wang, W.-T. and Huang, H.-C. (2015). Regularized principal component analysis for spatial data. arXiv:1501.03221.
}

\seealso{
\code{\link{cv.spatpca}}, \code{\link{plot.spatpca}}
}

