% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/routines.R
\name{subsetsearch}
\alias{subsetsearch}
\title{Search subsets for a property which is inherited in a particular way}
\usage{
subsetsearch(n, checkfun, testnull = TRUE, ...)
}
\arguments{
\item{n}{an integer such that the search is over all subsets of \eqn{\{1,...,n\}}}

\item{checkfun}{a function which takes arguments \code{zset}, a subset of \eqn{\{1,...,n\}} and ...
The function returns the value \code{TRUE} or \code{FALSE}. It needs to have the property that if it is \code{FALSE} for any
particular \code{zset}, it is also \code{FALSE} for all supersets of \code{zset}.}

\item{testnull}{If \code{TRUE}, then include the null subset in the search. If \code{FALSE}, do not test the
null subset.}

\item{...}{other arguments}
}
\value{
A list of all subsets for which the value is \code{TRUE}
}
\description{
The following routine returns a list of all subsets of a given set for which a specified property is \code{TRUE}.
 It is assumed that if the property is \code{FALSE} for any particular subset, it is also \code{FALSE} for all supersets of that subset.
 This enables a branch search strategy to be used to obviate the need to search over supersets of subsets already eliminated from consideration.
 It is used within the hierarchical search step of \code{\link{checkallmodels}}.
}
