require(methods)
setClass("matrix.csr",representation(ra="numeric",ja="numeric",ia="numeric", dimension="numeric"))
setClass("matrix.csc","matrix.csr")
setClass("matrix.ssr","matrix.csr")
setClass("matrix.ssc","matrix.csr")
setClass("matrix.csr.chol",representation(nrow="numeric",nnzlindx="numeric",
	nsuper="numeric",lindx="numeric",xlindx="numeric",nnzl="numeric",
	lnz="numeric",xlnz="numeric",invp="numeric",perm="numeric",
	xsuper="numeric",ierr="numeric",time="numeric"))
setClass("numeric or NULL")
setIs("numeric","numeric or NULL")
setIs("NULL","numeric or NULL")
setClass("character or NULL")
setIs("character","character or NULL")
setIs("NULL","character or NULL")
setClass("matrix.csc.hb",representation(ra="numeric",ja="numeric",ia="numeric", 
	rhs.ra="numeric",guess="numeric or NULL",xexact="numeric or NULL",dimension ="numeric",
	rhs.dim="numeric",rhs.mode="character or NULL"))
setClass("matrix.ssc.hb","matrix.csc.hb")
setClass("slm",representation("lm",coefficients="numeric",chol="matrix.csr.chol",
	residuals="numeric",fitted="numeric"))
setClass("summary.slm")
#--------------------------------------------------------------------
setGeneric("as.matrix.csr")
setMethod("as.matrix.csr","matrix.csc",as.matrix.csr.matrix.csc)
setMethod("as.matrix.csr","matrix.ssr",as.matrix.csr.matrix.ssr)
setMethod("as.matrix.csr","matrix.ssc",as.matrix.csr.matrix.ssc)
setGeneric("as.matrix.csc")
setMethod("as.matrix.csc","matrix.csr",as.matrix.csc.matrix.csr)
setMethod("as.matrix.csc","matrix.ssr",as.matrix.csc.matrix.ssr)
setMethod("as.matrix.csc","matrix.ssc",as.matrix.csc.matrix.ssc)
setGeneric("as.matrix.ssr")
setMethod("as.matrix.ssr","matrix.csr",as.matrix.ssr.matrix.csr)
setMethod("as.matrix.ssr","matrix.csc",as.matrix.ssr.matrix.csc)
setMethod("as.matrix.ssr","matrix.ssc",as.matrix.ssr.matrix.ssc)
setGeneric("as.matrix.ssc")
setMethod("as.matrix.ssc","matrix.csr",as.matrix.ssc.matrix.csr)
setMethod("as.matrix.ssc","matrix.csc",as.matrix.ssc.matrix.csc)
setMethod("as.matrix.ssc","matrix.ssr",as.matrix.ssc.matrix.ssr)
setMethod("as.matrix","matrix.csr",as.matrix.matrix.csr)
setMethod("as.matrix","matrix.csc",as.matrix.matrix.csc)
setMethod("as.matrix","matrix.ssr",as.matrix.matrix.ssr)
setMethod("as.matrix","matrix.ssc",as.matrix.matrix.ssc)
setMethod("t","matrix.csr",t.matrix.csr)
setMethod("t","matrix.csc",t.matrix.csc)
setMethod("dim","matrix.csr",dim.matrix.csr)
setMethod("dim","matrix.csc",dim.matrix.csc)
setMethod("dim","matrix.ssr",dim.matrix.ssr)
setMethod("dim","matrix.ssc",dim.matrix.ssc)
setMethod("diag","matrix.csr",diag.matrix.csr)
setMethod("diag<-","matrix.csr",diag.assign.matrix.csr)
setGeneric("chol")
setMethod("chol","matrix",chol.default)
setMethod("chol","matrix.csr",chol.matrix.csr)
setMethod("chol","matrix.csc",chol.matrix.csc)
setMethod("backsolve","matrix.csr.chol",backsolve.matrix.csr.chol)
setMethod("solve","matrix.csr",solve.matrix.csr)
setMethod("model.matrix","matrix.csc.hb",model.matrix.matrix.csc.hb)
setMethod("model.matrix","matrix.ssc.hb",model.matrix.matrix.ssc.hb)
setMethod("model.response","matrix.csc.hb",model.response.matrix.csc.hb)
setMethod("model.response","matrix.ssc.hb",model.response.matrix.csc.hb)
setMethod("%*%",signature(x="matrix.csr",y="matrix.csr"),.matmul.matrix.csr)
setMethod("%*%",signature(x="matrix.csr",y="numeric"),.matmul.matrix.csr)
setMethod("image","matrix.csr",image.matrix.csr)
setMethod("summary","slm",summary.slm)
setMethod("coef","slm",coef.slm)
setMethod("fitted","slm",fitted.slm)
setMethod("residuals","slm",residuals.slm)
setMethod("print","summary.slm",print.summary.slm)
#--------------------------------------------------------------------
