% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/window.R
\name{windowPartitionBy}
\alias{windowPartitionBy}
\alias{windowPartitionBy,character-method}
\alias{windowPartitionBy,Column-method}
\title{windowPartitionBy}
\usage{
windowPartitionBy(col, ...)

\S4method{windowPartitionBy}{character}(col, ...)

\S4method{windowPartitionBy}{Column}(col, ...)
}
\arguments{
\item{col}{A column name or Column by which rows are partitioned to
windows.}

\item{...}{Optional column names or Columns in addition to col, by
which rows are partitioned to windows.}
}
\description{
Creates a WindowSpec with the partitioning defined.
}
\note{
windowPartitionBy(character) since 2.0.0

windowPartitionBy(Column) since 2.0.0
}
\examples{
\dontrun{
  ws <- orderBy(windowPartitionBy("key1", "key2"), "key3")
  df1 <- select(df, over(lead("value", 1), ws))

  ws <- orderBy(windowPartitionBy(df$key1, df$key2), df$key3)
  df1 <- select(df, over(lead("value", 1), ws))
}
}
