% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\docType{methods}
\name{ifelse}
\alias{ifelse}
\alias{ifelse,Column-method}
\title{ifelse}
\usage{
\S4method{ifelse}{Column}(test, yes, no)
}
\arguments{
\item{test}{a Column expression that describes the condition.}

\item{yes}{return values for \code{TRUE} elements of test.}

\item{no}{return values for \code{FALSE} elements of test.}
}
\description{
Evaluates a list of conditions and returns \code{yes} if the conditions are satisfied.
Otherwise \code{no} is returned for unmatched conditions.
}
\note{
ifelse since 1.5.0
}
\examples{
\dontrun{
ifelse(df$a > 1 & df$b > 2, 0, 1)
ifelse(df$a > 1, df$a, 1)
}
}
\seealso{
\link{when}

Other normal_funcs: \code{\link{abs}},
  \code{\link{bitwiseNOT}}, \code{\link{coalesce}},
  \code{\link{column}}, \code{\link{expr}},
  \code{\link{greatest}}, \code{\link{isnan}},
  \code{\link{least}}, \code{\link{lit}},
  \code{\link{nanvl}}, \code{\link{negate}},
  \code{\link{randn}}, \code{\link{rand}},
  \code{\link{struct}}, \code{\link{when}}
}
