% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/functions.R
\docType{methods}
\name{dense_rank}
\alias{dense_rank}
\alias{dense_rank}
\alias{dense_rank,missing-method}
\title{dense_rank}
\usage{
dense_rank(x = "missing")

\S4method{dense_rank}{missing}()
}
\arguments{
\item{x}{empty. Should be used with no argument.}
}
\description{
Window function: returns the rank of rows within a window partition, without any gaps.
The difference between rank and dense_rank is that dense_rank leaves no gaps in ranking
sequence when there are ties. That is, if you were ranking a competition using dense_rank
and had three people tie for second place, you would say that all three were in second
place and that the next person came in third. Rank would give me sequential numbers, making
the person that came in third place (after the ties) would register as coming in fifth.
}
\details{
This is equivalent to the \code{DENSE_RANK} function in SQL.
}
\note{
dense_rank since 1.6.0
}
\examples{
\dontrun{
  df <- createDataFrame(mtcars)
  ws <- orderBy(windowPartitionBy("am"), "hp")
  out <- select(df, over(dense_rank(), ws), df$hp, df$am)
}
}
\seealso{
Other window_funcs: \code{\link{cume_dist}},
  \code{\link{lag}}, \code{\link{lead}},
  \code{\link{ntile}}, \code{\link{percent_rank}},
  \code{\link{rank}}, \code{\link{row_number}}
}
