% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/column.R, R/functions.R
\docType{class}
\name{column}
\alias{column}
\alias{Column-class}
\alias{column}
\alias{column,jobj-method}
\alias{column}
\alias{column,character-method}
\title{S4 class that represents a SparkDataFrame column}
\usage{
column(x)

\S4method{column}{jobj}(x)

\S4method{column}{character}(x)
}
\arguments{
\item{x}{Character column name.}
}
\description{
The column class supports unary, binary operations on SparkDataFrame columns

Returns a Column based on the given column name.
}
\section{Slots}{

\describe{
\item{\code{jc}}{reference to JVM SparkDataFrame column}
}}

\note{
Column since 1.4.0

column since 1.6.0
}
\examples{
\dontrun{column("name")}
}
\seealso{
Other normal_funcs: \code{\link{abs}},
  \code{\link{bitwiseNOT}}, \code{\link{coalesce}},
  \code{\link{expr}}, \code{\link{greatest}},
  \code{\link{ifelse}}, \code{\link{isnan}},
  \code{\link{least}}, \code{\link{lit}},
  \code{\link{nanvl}}, \code{\link{negate}},
  \code{\link{randn}}, \code{\link{rand}},
  \code{\link{struct}}, \code{\link{when}}
}
