% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simList-accessors.R
\docType{methods}
\name{modules}
\alias{depends}
\alias{depends,.simList-method}
\alias{depends<-}
\alias{depends<-,.simList-method}
\alias{modules}
\alias{modules,.simList-method}
\alias{modules<-}
\alias{modules<-,.simList-method}
\alias{simList-accessors-modules}
\title{Simulation modules and dependencies}
\usage{
modules(object, hidden = FALSE)

\S4method{modules}{.simList}(object, hidden = FALSE)

modules(object) <- value

\S4method{modules}{.simList}(object) <- value

depends(object)

\S4method{depends}{.simList}(object)

depends(object) <- value

\S4method{depends}{.simList}(object) <- value
}
\arguments{
\item{object}{A \code{simList} simulation object.}

\item{hidden}{Logical. If TRUE, show the default core modules.}

\item{value}{The object to be stored at the slot.}
}
\value{
Returns or sets the value of the slot from the \code{simList} object.
}
\description{
Accessor functions for the \code{depends} and \code{modules} slots in a
\code{simList} object.
These are included for advanced users.
\tabular{ll}{
   \code{\link{depends}} \tab List of simulation module dependencies. (advanced) \cr
   \code{\link{modules}} \tab List of simulation modules to be loaded. (advanced) \cr
   \code{\link{inputs}} \tab List of loaded objects used in simulation. (advanced) \cr
}
}
\details{
Currently, only get and set methods are defined. Subset methods are not.
}
\author{
Alex Chubaty
}
\seealso{
\code{\link{SpaDES}}, specifically the section 1.2.7 on Modules and dependencies.

Other functions to access elements of a \code{simList} object: \code{\link{.addDepends}},
  \code{\link{doEvent.checkpoint}}, \code{\link{envir}},
  \code{\link{events}}, \code{\link{globals}},
  \code{\link{inputs}}, \code{\link{ls.simList}},
  \code{\link{ls.str.simList}}, \code{\link{objs}},
  \code{\link{packages}}, \code{\link{params}},
  \code{\link{paths}}, \code{\link{progressInterval}},
  \code{\link{times}}
}

