% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shine.R
\docType{methods}
\name{shine}
\alias{shine}
\alias{shine,simList-method}
\title{Display a simple, interactive shiny app of the simList}
\usage{
shine(sim, title = "SpaDES App", debug = FALSE, ...)

\S4method{shine}{simList}(sim, title = "SpaDES App", debug = FALSE, ...)
}
\arguments{
\item{sim}{a simList object}

\item{title}{character string. The title of the shiny page.}

\item{debug}{Logical. If TRUE, then will show spades event debugger in
console.}

\item{...}{additional arguments. Currently not used}
}
\description{
Currently, this is quite simple. It creates a side bar with the simulation
times, plus a set of tabs, one for each module, with numeric sliders.
Currently, this does not treat NAs correctly. Also, it is slow (shiny is not
built to be fast out of the box). Currently, it does not show plotting
updates; it only shows the final output of a spades call. There are two
buttons, one to run the entire spades call, the other to do just one time
step at a time. It can be repeatedly pressed.
}
\note{
Many module parameters are only accessed by modules at the start of a
  model run. So, even if the user changes them mid run, there won't be an
  effect on the model runs until \code{Reset} is pressed, and one of the Run
  buttons is pressed.

\code{.plotInterval} changes will only affect plots that are the base
  layer of a given plot image. If there are layers on top of a base layer
  (e.g., an agent on top of a raster layer), the .plotInterval of the
  overlayed layers is ignored.
}
\examples{
\dontrun{
times <- list(start = 0.0, end = 20.0)
parameters <- list(
  .globals = list(stackName = "landscape", burnStats = "nPixelsBurned"),
  .progress = list(NA),
  randomLandscapes = list(nx = 100L, ny = 100L, inRAM = TRUE),
  fireSpread = list(nFires = 10L, spreadprob = 0.225, its = 1e6, persistprob = 0,
                    returnInterval = 10, startTime = 0,
                    .plotInitialTime = 0.0, .plotInterval = 10),
  caribouMovement = list(N = 100L, moveInterval = 1,
                         .plotInitialTime = 1, .plotInterval = 1)
)
modules <- list("randomLandscapes", "fireSpread", "caribouMovement")
path <- list(modulePath = system.file("sampleModules", package = "SpaDES"),
             outputPath = file.path(tempdir(), "simOutputs"))

mySim <- simInit(times = times, params = parameters, modules = modules, path = path)

shine(mySim)

# if the user wants to see the events go by, which can help with debugging:
shine(mySim, debug=TRUE)
}
}

