% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module-define.R
\name{defineParameter}
\alias{defineParameter}
\title{Define a parameter used in a module}
\usage{
defineParameter(name, class, default, min, max, desc, ...)
}
\arguments{
\item{name}{Character string giving the parameter name.}

\item{class}{Character string giving the parameter class.}

\item{default}{The default value to use when none is specified by the user.
Non-standard evaluation is used for the expression.}

\item{min}{With \code{max}, used to define a suitable range of values.
Non-standard evaluation is used for the expression.
\emph{These are not tested by} \code{simInit} \emph{or}
\code{spades}. These are primarily for human use, i.e., to
tell a module user what values the module expects.}

\item{max}{With \code{min}, used to define a suitable range of values.
Non-standard evaluation is used for the expression.
\emph{These are not tested by} \code{simInit} \emph{or}
\code{spades}. These are primarily for human use, i.e., to
tell a module user what values the module expects.}

\item{desc}{Text string providing a brief description of the parameter.
If there are extra spaces or carriage returns, these will be stripped,
allowing for multi-line character strings without using \code{paste}
or multiple quotes.}

\item{...}{A convenience that allows writing a long \code{desc} without
having to use \code{paste}; any character strings after \code{desc}
will be \code{paste}d together with \code{desc}.}
}
\value{
a \code{data.frame}
}
\description{
Used to specify a parameter's name, value, and set a default. The \code{min} and
\code{max} arguments are ignored by \code{simInit} or \code{spades}; they
are for human use only. To ensure that a user cannot set parameters outside of
a range of values, the module developer should use assertions in their module
code.
}
\note{
Be sure to use the correct NA type: logical (\code{NA}), integer (\code{NA_integer_}),
real (\code{NA_real_}), complex (\code{NA_complex_}), or character (\code{NA_character_}).
See \code{\link[=NA]{NA()}}.
}
\examples{
parameters = rbind(
  defineParameter("lambda", "numeric", 1.23, desc = "intrinsic rate of increase"),
  defineParameter("P", "numeric", 0.2, 0, 1, "probability of attack"),

  # multi-line desc without quotes on each line -- spaces and carriage returns are stripped
  defineParameter("rate", "numeric", 0.2, 0, 1,
                  "rate of arrival. This is in individuals
                  per day. This can be modified
                  by the user"),
  # multi-line desc with quotes on each line
  defineParameter("times", "numeric", 0.2, 0, 1,
                  desc = "The times during the year ",
                         "that events will occur ",
                         "with possibility of random arrival times")

)

\donttest{
# Create a new module, then access parameters using `P`
tmpdir <- file.path(tempdir(), "test")
checkPath(tmpdir, create = TRUE)

# creates a  new, "empty" module -- it has defaults for everything that is required
newModule("testModule", tmpdir, open = FALSE)

# Look at new module code -- see defineParameter
if (interactive()) file.edit(file.path(tmpdir, "testModule", "testModule.R"))

# initialize the simList
if (requireNamespace("ggplot2", quietly = TRUE)) {
  # Some things not necessary in this example, if not interactive (like plotting)
  opts <- if (interactive()) list() else
    options(spades.plot = NA, spades.useRequire = FALSE,
            spades.moduleCodeChecks = FALSE)
  mySim <- simInit(modules = "testModule",
                   paths = list(modulePath = tmpdir))

  # Access one of the parameters -- because this line is not inside a module
  #  function, we must specify the module name. If used within a module,
  #  we can omit the module name
  P(mySim, module = "testModule") # gets all params in a module
  P(mySim, ".useCache", "testModule") # just one param
  options(opts)
}
unlink(tmpdir, recursive = TRUE)
}

}
\seealso{
\code{\link[=P]{P()}}, \code{\link[=params]{params()}} for accessing these parameters in a module.
}
\author{
Alex Chubaty and Eliot McIntire
}
