% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module-template.R
\name{newModuleTests}
\alias{newModuleTests}
\alias{newModuleTests,character,character,logical,logical-method}
\title{Create template testing structures for new modules}
\usage{
newModuleTests(name, path, open, useGitHub)

\S4method{newModuleTests}{character,character,logical,logical}(name, path, open, useGitHub)
}
\arguments{
\item{name}{Character string specifying the name of the new module.}

\item{path}{Character string. Subdirectory in which to place the new module code file.
The default is the current working directory.}

\item{open}{Logical. Should the new module file be opened after creation?
Default \code{TRUE} in an interactive session.}

\item{useGitHub}{Logical indicating whether GitHub will be used.
If \code{TRUE} (default), creates suitable configuration files (e.g.,
\file{.gitignore}) and configures basic GitHub actions for module code checking.}
}
\value{
Nothing is returned. Invoked for its side effect of creating new module test files.
}
\description{
Create template testing structures for new modules
}
\seealso{
Other module creation helpers: 
\code{\link{newModuleCode}()},
\code{\link{newModuleDocumentation}()},
\code{\link{newModule}()}
}
\author{
Eliot McIntire and Alex Chubaty
}
\concept{module creation helpers}
