% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc-methods.R
\docType{methods}
\name{loadPackages}
\alias{loadPackages}
\alias{loadPackages,character-method}
\alias{loadPackages,list-method}
\alias{loadPackages,NULL-method}
\title{Load packages.}
\usage{
loadPackages(packageList, install = FALSE, quiet = TRUE)

\S4method{loadPackages}{character}(packageList, install = FALSE,
  quiet = TRUE)

\S4method{loadPackages}{list}(packageList, install = FALSE, quiet = TRUE)

\S4method{loadPackages}{`NULL`}(packageList, install = FALSE, quiet = TRUE)
}
\arguments{
\item{packageList}{A list of character strings specifying
the names of packages to be loaded.}

\item{install}{Logical flag. If required packages are not
already installed, should they be installed?}

\item{quiet}{Logical flag. Should the final "packages loaded"
message be suppressed?}
}
\value{
Specified packages are loaded and attached using \code{require()},
        invisibly returning a logical vector of successes.
}
\description{
Load and optionally install additional packages.
}
\examples{
\dontrun{
  pkgs <- list("raster", "lme4")
  loadPackages(pkgs) # loads packages if installed
  loadPackages(pkgs, install = TRUE) # loads packages after installation (if needed)
}

}
\seealso{
\code{\link{require}}.
}
\author{
Alex Chubaty
}
