% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sptemnt_cusum.R
\name{sptemnt_cusum}
\alias{sptemnt_cusum}
\title{Online spatio-temporal process monitoring by a CUSUM chart}
\usage{
sptemnt_cusum(
  y,
  st,
  type,
  ARL0 = 200,
  gamma = 0.1,
  B = 1000,
  bs = 5,
  T = 1,
  ht = NULL,
  hs = NULL,
  gt = NULL,
  gs = NULL
)
}
\arguments{
\item{y}{A vector of \eqn{N} spatio-temporal observations.}

\item{st}{An \eqn{N\times 3} matrix specifying the spatial locations and times for 
all the spatio-temporal observations in \code{y}.}

\item{type}{A vector of \eqn{N} characters specifying the types of the observations. 
Here, \code{type} could be \code{IC1}, \code{IC2} or \code{Mnt}, where 
\code{type='IC1'} denotes the in-control (IC) observations used to perform 
the block bootstrap procedure to determine the control limit of the CUSUM 
chart, \code{type='IC2'} denotes the IC observations used to estimate the 
spatio-temporal mean and covariance functions by \code{spte_meanest} and 
\code{spte_covest}, and \code{type='Mnt'} denotes the observations used 
for online process monitoring (cf., Yang and Qiu 2020). If there are only 
data points with either \code{type='IC1'} or \code{type='IC2'}, then these 
data points will be used to estimate the model and conduct the bootstrap 
procedure as well. This function will return an error if there are no 
observations with \code{type='IC1'} or \code{type='IC2'}.}

\item{ARL0}{The pre-specified IC average run length. Default is 200.}

\item{gamma}{The pre-specified allowance constant in the CUSUM chart. Default is 0.1.}

\item{B}{The bootstrap sizes used in the block bootstrap procedure for determining 
the control limit. Default value is 1,000.}

\item{bs}{The block size of the block bootstrap procedure. Default value is 5.}

\item{T}{The period of the spatio-temporal mean and covariance. Default value is 1.}

\item{ht}{The temporal kernel bandwidth \code{ht}; default is \code{NULL} and it will 
be chosen by the modified cross-validation via \code{mod_cv} if \code{ht=NULL}.}

\item{hs}{The spatial kernel bandwidth \code{hs}; default is \code{NULL},  and it will 
be chosen by the function \code{mod_cv} if \code{hs=NULL}.}

\item{gt}{The temporal kernel bandwidth \code{gt}; default is \code{NULL} and it will 
be chosen by minimizing the mean squared prediction error via \code{cv_mspe} 
if \code{gt=NULL}.}

\item{gs}{The spatial kernel bandwidth \code{gs}; default is \code{NULL},  and it will 
be chosen by the function \code{cv_mspe} if \code{gs=NULL}.}
}
\value{
\item{ARL0}{Same as the one in the arguments.}
\item{gamma}{Same as the one in the arguments.}
\item{cstat}{The charting statistics which can be used to make 
a plot for the control chart.}
\item{cl}{The control limit that is determined by the block bootstrap.}
\item{signal_time}{The signal time (i.e., the first time point when the 
charting statistic \code{cstat} exceeds the control limit \code{cl}).}
}
\description{
The function \code{sptemnt_cusum} implements the sequential online monitoring 
procedure described in Yang and Qiu (2020).
}
\examples{
library(SpTe2M)
data(ili_dat)
n <- 365; m <- 67
y <- ili_dat$Rate; st <- ili_dat[,3:5]
type <- rep(c('IC1','IC2','Mnt'),c(m*(n+1),(m*n),(m*n)))
ids <- c(1:(5*m),((n+1)*m+1):(m*(n+6)),((2*n+1)*m+1):(m*(2*n+6)))
y.sub <- y[ids]; st.sub <- st[ids,]; type.sub <- type[ids]
ili.cusum <- sptemnt_cusum(y.sub,st.sub,type.sub,ht=0.05,hs=6.5,gt=0.25,gs=1.5)
}
\references{
Yang, K. and Qiu, P. (2020). Online Sequential Monitoring of Spatio-Temporal 
Disease Incidence Rates. \emph{IISE Transactions}, \strong{52}, 1218-1233.
}
\author{
Kai Yang \email{kayang@mcw.edu} and Peihua Qiu
}
\keyword{sptemnt_cusum}
