% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/youth_network_shape.R
\name{youth_network_shape}
\alias{youth_network_shape}
\title{Format data for input into the youth Sojourn method's neural networks}
\usage{
youth_network_shape(
  data,
  sojourns = TRUE,
  RAW = FALSE,
  epoch = 1,
  verbose = TRUE,
  expand = TRUE,
  time_var = "Timestamp",
  first_print = TRUE,
  ...
)
}
\arguments{
\item{data}{a data frame of monitor and demographic data to format}

\item{sojourns}{logical. Should the data be windowed by Sojourn (TRUE) or
with a static window (15-s; FALSE)?}

\item{RAW}{logical. Are the data raw acceleration?}

\item{epoch}{numeric. The epoch length of the data. Values other than one are
not recommended.}

\item{verbose}{logical. Print processing updates to the console?}

\item{expand}{logical. Should collapsed data be replicated to match the
length of the original input?}

\item{time_var}{character scalar giving the variable name in \code{data} that
gives the timestamps}

\item{first_print}{logical. Print extra information?}

\item{...}{further arguments passed to \link{messager}}
}
\value{
A data frame containing data that are ready for making predictions
  with the youth Sojourn method's neural networks
}
\description{
Format data for input into the youth Sojourn method's neural networks
}
\keyword{internal}
