\name{packageAdd}
\alias{packageAdd}
\title{ Add contents of R source files to a source package}
\description{
  The contents of one or more files of R  source code will be added to the specified source package: the files themselves will be added to the \code{R} directory, and shells for the  documentation will be added to the \code{man} directory.  Unlike \code{\link{package.skeleton}}, this function does not require one function per source file and supports both class and method definitions.
}
\usage{
packageAdd(pkg, files, path = ".", document = TRUE)
}
\arguments{
  \item{pkg}{ The name of the package.  It must be attached to the session. }
  \item{files}{ The names of the files containing the R source to add to the package. }
  \item{path}{ The directory under which the source for \code{pkg} is stored. }
  \item{document}{ Should a skeleton documentation for the objects be generated? }
}
\details{
  The file of source code is copied unchanged to the  \code{"R"} subdirectory of the source package.  A shell of documentation is initialized for all the objects created by the evaluating the file.

If the file generates several function objects, the documentation shells for all of these, as generated by the \code{\link{prompt}()} function, are merged and stored under the name of the file, suffix \code{".Rd"}, in the \code{"man"} subdirectory of the package.

Currently method and class documentation are generated on separate files rather than being merged with function documentation.
}
\value{
Nothing useful.  Called for its side effects.
 }
\seealso{  \code{\link{promptAll}}}
\examples{
\dontrun{
packageAdd("SoDA", "triDiagonal.R", "~/RPackage")
}
}
\keyword{ documentation }
\keyword{ programming }
