% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grabLast.R
\name{grabLast}
\alias{grabLast}
\title{Get the final set of characters after a single-character delimeter}
\usage{
grabLast(vec, split.char)
}
\arguments{
\item{vec}{Character vector (usually containing filenames)}

\item{split.char}{A single character used to split the character strings}
}
\value{
Character vector of the strings that appear after the last instance of \code{split.char}
}
\description{
Get the final set of characters from a vector after a single-character delimeter.  This can be useful in
filename manipulations, among other things.
}
\examples{
grabLast(c(a="email@nowhere.com", "this.has.no.at.sign", "@",
             "bad.email@weird.com@", NA, "2at's@email@good.net"), "@")
}
\seealso{
Additional functions for filename manipulations:  \code{\link{stripExtension}}, \code{\link{getExtension}},
\code{\link{stripPath}}, \code{\link{getPath}}, \code{\link{basename}}, \code{\link{dirname}}
}
\author{
Landon Sego
}
\keyword{misc}
