% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectElements.R
\name{selectElements}
\alias{selectElements}
\title{Validate selected elements from a character vector}
\usage{
selectElements(elements, cVec)
}
\arguments{
\item{elements}{elements to select from \code{cVec}.  Can be a logical vector, a vector of numeric indexes,
or a character vector of element names.  Note that logical vectors are not recycled as usual:
they must be the same length as \code{cVec}. If \code{elements == NULL}, \code{NULL} is returned.}

\item{cVec}{A character vector from which to select elements (such as row names or column names)}
}
\value{
A character vector with elements that were selected from \code{cVec} using \code{elements}
}
\description{
Validate selected elements from a character vector using a variety of selection mechanisms:  logical, names, or
numerical indexes
}
\details{
This function is especially useful for selecting rows or columns from data frames, while providing informative error messages
if the \code{elements} for selection are specified incorrectly.
}
\examples{
# Define some "column names"
cnames <- letters[1:5]
cnames

# Select the 1st and 3rd column names using a variety of approaches
selectElements(c("a", "c"), cnames)
selectElements(c(1, 3), cnames)
selectElements(c(TRUE, FALSE, TRUE, FALSE, FALSE), cnames)

# Select the 1st, 3rd, and 1st columns
selectElements(c("a", "c", "a"), cnames)
selectElements(c(1, 3, 1), cnames)

# If you don't want to select any of them
selectElements(NULL, cnames)
}

