% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SmCCNetSource.R
\name{plotMultiOmicsNetwork}
\alias{plotMultiOmicsNetwork}
\title{Plot multi-omics module networks.}
\usage{
plotMultiOmicsNetwork(Abar, CorrMatrix, multiOmicsModule, ModuleIdx, P1,
  EdgeCut = 0, FeatureLabel = NULL, AddCorrSign = TRUE, SaveFile = NULL,
  ShowType1Label = TRUE, ShowType2Label = TRUE, PlotTitle = "",
  NetLayout = "lgl", ShowNodes = TRUE, VertexLabelCex = 1,
  VertexSize = 1)
}
\arguments{
\item{Abar}{A \eqn{p\times p} similary matrix for both omics data types
based on pseudo canonical correlation weights. \eqn{p} is the number of 
total features for the two omics data types. All entries are non-negative.}

\item{CorrMatrix}{A \eqn{p\times p} correlation matrix that provides sign
information for the network.}

\item{multiOmicsModule}{A list of multi-omics modules.}

\item{ModuleIdx}{Index for the module to be plotted. It can not exceed the
length of \code{multiOmicsModule}.}

\item{P1}{Total number of features for the first omics data type.}

\item{EdgeCut}{A numerical value between 0 and 1, indicating an edge
threshold for the network. Any features (network nodes) without any edge
strength that passes the threshold are excluded from the figure. If 
\code{EdgeCut = 0} (default), then the full module network will be created.}

\item{FeatureLabel}{A \eqn{1\times p} vector indicating feature names. If
\code{FeatureLabel = NULL} (default), the feature names will be 
\eqn{\{TypeI_1, \cdots, TypeI_{p_1}, TypeII_1, \cdots, TypeII_{p-p_1}\}}, 
where \eqn{p_1 = }\code{P1}.}

\item{AddCorrSign}{Logical. Whether to add a positive or negative sign to
each network edge based on pairwise feature correlations.}

\item{SaveFile}{A pdf file name for the figure output. 
If \code{SaveFile = NULL} (default), the figure will not be saved.}

\item{ShowType1Label}{Logical. Whether to label the network nodes for the
first omics data type.}

\item{ShowType2Label}{Logical. Whether to label the network nodes for the
second omics data type.}

\item{PlotTitle}{A title for the figure. Default is without any title.}

\item{NetLayout}{Graphical layout for the network. Possible options are
\code{circle} for circle layout, \code{sphere} for 3D sphere, \code{fr} for
Fruchterman-Reinhold, and \code{lgl} for the LGL algorithm. Refer to igraph 
manual for more details on the layout options.}

\item{ShowNodes}{Logical. Whether to show network nodes.}

\item{VertexLabelCex}{Scaling factor for the vertex labels.}

\item{VertexSize}{Size of the vertices.}
}
\value{
A multi-omics network figure.
}
\description{
Plot multi-omics modules based on similarity matrix derived from pseudo
canonical weights and pairwise feature correlations.
}
\examples{
set.seed(123)
w <- rnorm(5)
w <- w/sqrt(sum(w^2))
abar <- getAbar(w, P1 = 2, FeatureLabel = NULL)
modules <- getMultiOmicsModules(abar, P1 = 2, CutHeight = 0.5)
x <- cbind(geneExpr[ ,seq_len(2)], mirnaExpr[ , seq_len(3)])
corr <- cor(x)

plotMultiOmicsNetwork(abar, corr, modules, ModuleIdx = 1, P1 = 2)

}
