% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairsetinval.R
\name{pairsetinval}
\alias{pairsetinval}
\title{Estimating initial values for paired slapmeg based on seperate lme models}
\usage{
pairsetinval(index, fixed, random, subject, data)
}
\arguments{
\item{index}{Indexes of pairs used for replacing the parameters in the jopint model}

\item{fixed}{A two-sided linear formula object for specifying the
fixed-effects in the linear mixed model at the latent process level. Names
of omics in the pathway are separated by \code{+} on the left of \code{~} and the
covariates are separated by \code{+} on the right of the \code{~}. For
identifiability purposes, the intercept should always be present in the model.}

\item{random}{A one-sided formula for the random-effects in the
latent process mixed model and starts with the \code{~} sign. At least one random
effect should be included. Covariates with a random-effect are separated
by \code{+}.}

\item{subject}{name of the covariate representing the repeated measures structure such as subject IDs.}

\item{data}{data frame containing the variables named in \code{fixed}, \code{random},
\code{grouping} and \code{subject}.}
}
\value{
A list of vectors, each including vector of initial values corresponding to pairs based on the
index file. These vectors will be used as input for multlcmm function of each paired model.
}
\description{
A seperate lme model is fited per omic in the pathway and the estimates are combined based on the indexes
of pairs to create initial values for the \code{\link{pairslapmeg}} function.
}
\author{
Mitra Ebrahimpoor
\email{m.ebrahimpoor@lumc.nl}
}
