% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SkeweDF_functions.R
\name{plot_model}
\alias{plot_model}
\title{Plot Model Helper Function}
\usage{
plot_model(
  title,
  model_fn_name,
  data,
  parameter_df,
  n_parameters,
  plot_folder_name,
  xlab,
  left_trunc = 1
)
}
\arguments{
\item{title}{Character vector indicating title of the empirical dataset, this will be present on every plot, this also determines the name of the folder where plots will be}

\item{model_fn_name}{Character vector used to indicate name of model function used for optimization}

\item{data}{Vector of observed values}

\item{parameter_df}{Data frame of optimized parameters and other model function values (p0, Psi, etc)}

\item{n_parameters}{Int of number of parameters used in model funciton}

\item{plot_folder_name}{Character vector indicating folder or directory name to be used when outputting plot images}

\item{xlab}{Character vector indicating x axis label of plots, indicates what the random variable is}

\item{left_trunc}{Int indicating starting index of model function used for optimization}
}
\description{
This function generates various plots of empirical data and models
}
