% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Alt_Alg.R
\name{Alt_Alg}
\alias{Alt_Alg}
\title{Calculates the residence times and identifies the sites of interest}
\usage{
Alt_Alg(Name, t, X, Y, R, s = 10, m = 500, first = 'n', save = 'n')
}
\arguments{
\item{Name}{name of the data, which is used for any saved files and plot titles}

\item{t}{array of the times that the positions are recorded at}

\item{X}{array of the x-coordinates describing the trajectory}

\item{Y}{array of the y-coordinates describing the trajectory}

\item{R}{radius value to use}

\item{s}{number of time steps between checks for entrances and exits}

\item{m}{estimate of the maximum number of crossings across all circles}

\item{first}{if \code{'y'}, the algorithm will look for the second greatest maximum percent drop if the first results in the first circle being the only non-identified site}

\item{save}{if \code{'y'}, save the files}
}
\value{
max_percent_drop - maximum percent drop, which is the relative difference between the bars, indicating the difference between sites and non-site circles

number_identified_sites - number of circles identified as sites of interest
}
\description{
From positional data, this function finds the residence times as well as the number of visits. It also identifies which areas are sites of interest.
}
\details{
This is the main part of the algorithm. Given the trajectory of an animal, the algorithm centres a circle at the start of the trajectory. The next circle is centred at the point when the animal first leaves the previous circle. This is then repeated all along the trajectory until the whole trajectory is covered. The algorithm then finds the times of when the animal has crossed the perimeter of these circles, the results of which are saved in two csv files (comma separated values), with titles `\emph{Name}'_F_alt_R`\emph{R}'.csv and `\emph{Name}'_B_alt_R`\emph{R}'.csv for the forward and backward crossings respectively. A forward crossing is one that occurs after the time point that the circle is centred on and backward crossings occur before this.

The residence times and number of visits for each circle are calculated, which is also stored in a csv file with the title `\emph{Name}'_UD_alt_R`\emph{R}'.csv. The function orders all the circles in descending order of residence time and then moving down the list, any that overlap with one of a higher residence time are removed. The relative difference between consecutive residence times (percent drops) are calculated and the maximum is identified (\code{maximum_percent_drop}). The number of identified sites (\code{Number_identified_sites}) is the number of circles before this maximum percent drop. This can be seen visually, using \code{\link{plot_bar_chart}}.
}
\examples{
\donttest{##Find the current working directory
wd = getwd()
##Set the working directory as the temporary one
setwd(tempdir())
##Load the data
data(OU_14)
t=unlist(OU_14["t"])
X=unlist(OU_14["X"])
Y=unlist(OU_14["Y"])

##Calculate the residence time with a radius of 0.3 and not including the first circle
Alt_Alg("OU_14",t,X,Y,0.3,first='y',save='y')

##Reset the original working directory
setwd(wd)}
}
\references{
Munden, R., Borger , L., Wilson, R.P., Redcliffe, J., Loison, A., Garel, M. and Potts, J.P. in review. Making sense of ultra-high-resolution movement data: an algorithm for inferring sites of interest.
}
\author{
Rhys Munden <rdmunden1@sheffield.ac.uk>
}
