## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## -----------------------------------------------------------------------------
library(SimplyAgree)

## -----------------------------------------------------------------------------
a1 = agree_test(x = reps$x,
                y = reps$y,
                agree.level = .8)

## -----------------------------------------------------------------------------
print(a1)

## ---- fig.width=6, fig.height=6-----------------------------------------------
plot(a1, type = 1)

plot(a1, type = 2) 

## -----------------------------------------------------------------------------
a2 = agree_reps(x = "x",
                y = "y",
                id = "id",
                data = reps,
                agree.level = .8)

## -----------------------------------------------------------------------------
print(a2)

## ---- fig.width=6, fig.height=6-----------------------------------------------
plot(a2, type = 1)

plot(a2, type = 2)

## -----------------------------------------------------------------------------
a3 = agree_nest(x = "x",
                y = "y",
                id = "id",
                data = reps,
                agree.level = .8)

## -----------------------------------------------------------------------------
print(a3)

## ---- fig.width=6, fig.height=6-----------------------------------------------
plot(a3, type = 1)

plot(a3, type = 2)

## ----warning=FALSE,eval=FALSE-------------------------------------------------
#  a4 = loa_mixed(data = recpre_long,
#                 diff = "diff",
#                 condition = "trial_condition",
#                 id = "id",
#                 plot.xaxis = "AM",
#                 replicates = 199,
#                 type = "perc")

## -----------------------------------------------------------------------------
  sf <- matrix(
    c(9,    2,   5,    8,
      6,    1,   3,    2,
      8,    4,   6,    8,
      7,    1,   2,    6,
      10,   5,   6,    9,
      6,   2,   4,    7),
    ncol = 4,
    byrow = TRUE
  )

  colnames(sf) <- paste("J", 1:4, sep = "")
  rownames(sf) <- paste("S", 1:6, sep = "")
  #sf  #example from Shrout and Fleiss (1979)
  dat = as.data.frame(sf)

## -----------------------------------------------------------------------------
test1 = reli_stats(
  data = dat,
  wide = TRUE,
  col.names = c("J1", "J2", "J3", "J4")
)

## -----------------------------------------------------------------------------
print(test1)

## ---- fig.width=6, fig.height=6-----------------------------------------------
plot(test1)

## -----------------------------------------------------------------------------
power_res <- blandPowerCurve(
  samplesizes = seq(10, 100, 1),
  mu = 0.5,
  SD = 2.5,
  delta = c(6,7),
  conf.level = c(.90,.95),
  agree.level = c(.8,.9)
)

head(power_res)

## -----------------------------------------------------------------------------
find_n(power_res, power = .8)

## ----fig.width=6, fig.height=6------------------------------------------------
plot(power_res)

