% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{test_par_dom}
\alias{test_par_dom}
\title{Simulate a Parallel Design and Test Difference of Means (DOM)}
\usage{
test_par_dom(
  n,
  muT,
  muR,
  SigmaT,
  SigmaR,
  lequi_tol,
  uequi_tol,
  alpha,
  dropout,
  typey,
  adseq,
  k,
  arm_seedT,
  arm_seedR,
  TART,
  TARR,
  vareq
)
}
\arguments{
\item{n}{integer number of subjects per arm}

\item{muT}{vector mean of endpoints on treatment arm}

\item{muR}{vector mean of endpoints on reference arm}

\item{SigmaT}{matrix covar-variance matrix on treatment arm across endpoints}

\item{SigmaR}{matrix covar-variance matrix on reference arm across endpoints}

\item{lequi_tol}{vector  lower equivalence tolerance band across endpoints}

\item{uequi_tol}{vector  upper equivalence tolerance band across endpoints}

\item{alpha}{vector alpha value across endpoints}

\item{dropout}{vector of size 2 with dropout proportion per arm (T,R)}

\item{typey}{vector with positions of primary endpoints}

\item{adseq}{boolean is used a sequential adjustment?}

\item{k}{integer minimum number of equivalent endpoints}

\item{arm_seedT}{integer seed for the simulation on treatment arm}

\item{arm_seedR}{integer seed for the simulation on reference arm}

\item{TART}{double treatment allocation rate for the treatment arm}

\item{TARR}{double treatment allocation rate for the reference arm}

\item{vareq}{boolean assumed equivalence variance between arms for the t-test}
}
\value{
A numeric matrix containing the simulated hypothesis test results.
The first column represents the overall equivalence decision, where 1 indicates
success and 0 indicates failure. The subsequent columns contain the hypothesis
test results for each endpoint, followed by mean estimates for the reference and
treatment groups, and standard deviations for the reference and treatment groups.
}
\description{
Simulates a parallel-group design and performs equivalence testing using the difference of means (DOM) approach.
This function evaluates whether the treatment and reference groups are equivalent based on predefined
equivalence margins and hypothesis testing criteria.
}
\details{
The function simulates a parallel-group study design and evaluates equivalence
using the difference of means (DOM) approach. It accounts for dropout rates and
treatment allocation proportions while generating simulated data based on the
specified covariance structure. The test statistics are computed, and a final
equivalence decision is made based on the predefined number of required significant
endpoints (\code{k}). If sequential testing (\code{adseq}) is enabled, primary endpoints
must establish equivalence before secondary endpoints are evaluated.
When \code{vareq = TRUE}, the test assumes equal variances between groups and
applies Schuirmann's two one-sided tests (TOST).
}
