% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_dist.R
\name{sim_distribution}
\alias{sim_distribution}
\title{Simulate spatial and temporal distribution}
\usage{
sim_distribution(
  sim,
  grid = make_grid(),
  ays_covar = sim_ays_covar(),
  depth_par = sim_parabola()
)
}
\arguments{
\item{sim}{A list with \code{ages}, \code{years}, and an abundance-at-age matrix,
like one produced by \code{\link[=sim_abundance]{sim_abundance()}}.}

\item{grid}{A \code{stars} object defining the survey grid, such as \code{\link{survey_grid}} or one created with \code{\link[=make_grid]{make_grid()}}.}

\item{ays_covar}{A closure that simulates age-year-space covariance, such as \code{\link[=sim_ays_covar]{sim_ays_covar()}}.}

\item{depth_par}{A closure that defines the relationship between abundance and depth,
such as \code{\link[=sim_parabola]{sim_parabola()}}.}
}
\value{
Appends the following objects to the \code{sim} list:
\itemize{
\item \code{grid}: A \code{stars} object with grid details
\item \code{grid_xy}: A \code{data.table} representation of the grid in XYZ format
\item \code{sp_N}: A \code{data.table} of abundance split by age, year, and cell
}
}
\description{
Provided with an abundance-at-age matrix and a survey grid, this function applies
correlated space–age–year error to simulate the spatial distribution of a population.
Simulation by length is not yet implemented.
}
\details{
This function simulates the probability of fish inhabiting a cell based on a parabolic
relationship with depth and spatially/temporally autocorrelated noise across age and year.

\strong{Warning:} Simulating a large grid across many ages and years may be computationally intensive.
Start with smaller simulations to test your setup.
}
\examples{
\donttest{
sim <- sim_abundance(ages = 1:5, years = 1:5) |>
  sim_distribution(
    grid = make_grid(res = c(20, 20)),
    ays_covar = sim_ays_covar(phi_age = 0.8, phi_year = 0.1),
    depth_par = sim_parabola(mu = 200, sigma = 50)
  )

head(sim$sp_N)
head(sim$grid_xy)
}

}
