% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_dist_spde.R
\name{sim_ays_covar_spde}
\alias{sim_ays_covar_spde}
\title{Simulate age-year-space covariance using SPDE approach}
\usage{
sim_ays_covar_spde(
  sd = 2.8,
  range = 300,
  model = "spde",
  phi_age = 0.5,
  phi_year = 0.9,
  group_ages = 5:20,
  group_years = NULL,
  mesh,
  barrier.triangles
)
}
\arguments{
\item{sd}{Variance (can be age specific)}

\item{range}{Decorrelation range}

\item{model}{String indicating "barrier" or "spde" to generate Q with}

\item{phi_age}{Defines autocorrelation through ages. Can be one value or
a vector of the same length as ages.}

\item{phi_year}{Defines autocorrelation through years. Can be one value
or a vector of the same length as years.}

\item{group_ages}{Make space-age-year variance equal across these ages}

\item{group_years}{Make space-age-year variance equal across these years}

\item{mesh}{The mesh used to generate the precision matrix}

\item{barrier.triangles}{the set of triangles in the barrier of the mesh
for the barrier model}
}
\value{
Returns a function for use in \code{\link{sim_distribution}}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Returns a function to use inside \code{\link{sim_distribution}} to
generate the error term.
}
\examples{

\donttest{

if (requireNamespace("INLA")) {

  ## Make a grid
  my_grid <- make_grid(res = c(10,10))

  ## Make a mesh based off it

  my_mesh <- make_mesh(my_grid)
  sim <- sim_abundance(ages = 1:10, years = 1:10) \%>\%
          sim_distribution(grid = my_grid,
                           ays_covar = sim_ays_covar_spde(phi_age = 0.8,
                                                          phi_year = 0.1,
                                                          model = "spde",
                                                          mesh = my_mesh),
                           depth_par = sim_parabola(mu = 200,
                                                    sigma = 50))
  plot_distribution(sim, ages = 1:5, years = 1:5, type = "heatmap")

}

}

}
