% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plots.R
\name{two.term.marginals.plot}
\alias{two.term.marginals.plot}
\title{Plot marginal distribution of HPO term pairs}
\usage{
two.term.marginals.plot(hpo.terms, term.descendancy.matrix, phi.trace,
  use.clinical.names = FALSE, n = 10, terms.to.use = NULL,
  limits = NULL)
}
\arguments{
\item{hpo.terms}{R-Object representation of HPO}

\item{term.descendancy.matrix}{Logical term descendancy matrix, dimensions symmetrically labelled by terms, and where by a cell value of TRUE indicates that the row is the ancestor of the column term (in the sense of the DAG structure of the HPO}

\item{phi.trace}{Delta trace output from \code{\link{sim.reg}} function, where the rows are the values of phi at each iteration}

\item{use.clinical.names}{Logical indicating whether to use full clinical names for the terms (TRUE) or just the codes (FALSE)}

\item{n}{Maximum number of terms for plot}

\item{terms.to.use}{Specify the terms to appear in the plot}

\item{limits}{Range of frequencies to set colours for}
}
\value{
ggplot2 plot object
}
\description{
Plots the marginal frequency of HPO terms pairs' inclusion in the phi parameter over the course of an application of \code{\link{sim.reg}} as heatmap
}

