% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_plots.R
\name{labs_from_labels}
\alias{labs_from_labels}
\title{Add ggplot axis labels from labels attribute}
\usage{
labs_from_labels(gg)
}
\arguments{
\item{gg}{a ggplot object}
}
\value{
a ggplot object
}
\description{
Add ggplot axis labels from labels attribute
}
\examples{
\donttest{
library("ggplot2")
test <- mtcars
# add a label attribute
attr(test$cyl, "label") <- "cylinders"

# plot witht the variable names as axis titles
gg1 <- ggplot(test, aes(x=wt, y=cyl)) +
  geom_point()
gg1

# add labels where defined in the attribute
gg2 <- ggplot(test, aes(x=wt, y=cyl)) +
  geom_point()

gg2 <- labs_from_labels(gg2)
gg2
}
}
