% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats_pdf.R
\name{stats_pdf}
\alias{stats_pdf}
\title{Calculate Theoretical Statistics for a Valid Power Method PDF}
\usage{
stats_pdf(c, method = c("Fleishman", "Polynomial"), alpha = 0.025, mu = 0,
  sigma = 1, lower = -10, upper = 10, sub = 1000)
}
\arguments{
\item{c}{a vector of constants c0, c1, c2, c3 (if \code{method} = "Fleishman") or c0, c1, c2, c3, c4, c5 (if \code{method} =
"Polynomial"), like that returned by \code{\link[SimMultiCorrData]{find_constants}}}

\item{method}{the method used to find the constants.  "Fleishman" uses Fleishman's third-order polynomial transformation and
"Polynomial" uses Headrick's fifth-order transformation.}

\item{alpha}{proportion to be trimmed from the lower and upper ends of the power method pdf (default = 0.025)}

\item{mu}{mean for the continuous variable (default = 0)}

\item{sigma}{standard deviation for the continuous variable (default = 1)}

\item{lower}{lower bound for integration of the standard normal variable Z that generates the continuous variable (default = -10)}

\item{upper}{upper bound for integration (default = 10)}

\item{sub}{the number of subdivisions to use in the integration; if no result, try increasing sub (requires longer
computation time; default = 1000)}
}
\value{
A vector with components:

\code{trimmed_mean} the trimmed mean value

\code{median} the median value

\code{mode} the mode value

\code{max_height} the maximum pdf height
}
\description{
This function calculates the 100*\code{alpha} percent symmetric trimmed mean (0 < \code{alpha} < 0.50), median,
    mode, and maximum height of a valid power method pdf, after using \code{\link[SimMultiCorrData]{pdf_check}}.  It will stop with
    an error if the pdf is invalid.  The equations are those from Headrick & Kowalchuk (2007, \doi{10.1080/10629360600605065}).
}
\examples{
\dontrun{
# Beta(a = 4, b = 2) Distribution:
con <- find_constants(method = "Polynomial", skews = -0.467707,
                      skurts = -0.375, fifths = 1.403122,
                      sixths = -0.426136)$constants
stats_pdf(c = con, method = "Polynomial", alpha = 0.025)
}
}
\references{
Please see references for \code{\link[SimMultiCorrData]{pdf_check}}.
}
\seealso{
\code{\link[SimMultiCorrData]{find_constants}}, \code{\link[SimMultiCorrData]{pdf_check}}
}
\keyword{statistics}
\keyword{theoretical,}
