% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intercorr_fleish.R
\name{intercorr_fleish}
\alias{intercorr_fleish}
\title{Fleishman's Third-Order Polynomial Transformation Intermediate Correlation Equations}
\usage{
intercorr_fleish(r, c, a)
}
\arguments{
\item{r}{either a scalar, in which case it represents pairwise intermediate correlation between standard normal variables,
or a vector of 3 values, in which case:
\deqn{r[1]*r[2] = \rho_{z1,z2},\ r[1]*r[3] = \rho_{z1,z3},\ r[2]*r[3] = \rho_{z2,z3}}}

\item{c}{a matrix with either 2 or 3 rows, each a vector of constants c0, c1, c2, c3, like that returned by
\code{\link[SimMultiCorrData]{find_constants}}}

\item{a}{a matrix of target correlations among continuous variables; if \code{nrow(a) = 1}, it represents a pairwise
correlation; if \code{nrow(a) = 2 or 3}, it represents a correlation matrix between two or three variables}
}
\value{
a list of length 1 for pairwise correlations or length 3 for three variables;
     if the inputs satisfy the equations, returns 0 for all list elements
}
\description{
This function contains Fleishman's third-order polynomial transformation intermediate correlation
    equations (Headrick & Sawilowsky, 1999, \doi{10.1007/BF02294317}).  It is used in \code{\link[SimMultiCorrData]{findintercorr}} and \code{\link[SimMultiCorrData]{findintercorr2}}
    to find the intermediate correlation for standard normal random variables which are used in the Fleishman
    polynomial transformation.  It can be used to verify a set of constants and an intermediate correlation satisfy
    the equations for the desired post-transformation correlation.  It works for two or three variables.  Headrick &
    Sawilowsky recommended using the technique of Vale & Maurelli (1983,
    \doi{10.1007/BF02293687}), in the case of more than 3 variables, in which
    the intermediate correlations are found pairwise and then eigen value decomposition is used on the correlation matrix.
    Note that there exist solutions that yield invalid power
    method pdfs (see \code{\link[SimMultiCorrData]{power_norm_corr}}, \code{\link[SimMultiCorrData]{pdf_check}}).
    This function would not ordinarily be called by the user.
}
\references{
Please see references for \code{\link[SimMultiCorrData]{findintercorr_cont}}.
}
\seealso{
\code{\link[SimMultiCorrData]{fleish}}, \code{\link[SimMultiCorrData]{power_norm_corr}},
    \code{\link[SimMultiCorrData]{pdf_check}}, \code{\link[SimMultiCorrData]{find_constants}}
}
\keyword{Fleishman}
\keyword{correlation,}
\keyword{intermediate,}
