% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chat_nb.R
\name{chat_nb}
\alias{chat_nb}
\title{Calculate Upper Frechet-Hoeffding Correlation Bound: Negative Binomial - Normal Variables}
\usage{
chat_nb(size, prob = NULL, mu = NULL, n_unif = 10000, seed = 1234)
}
\arguments{
\item{size}{a vector of size parameters for the Negative Binomial variables (see \code{\link[stats]{dnbinom}})}

\item{prob}{a vector of success probability parameters}

\item{mu}{a vector of mean parameters (*Note: either \code{prob} or \code{mu} should be supplied for all Negative Binomial variables,
not a mixture; default = NULL)}

\item{n_unif}{the number of uniform random numbers to generate in calculating the bound (default = 10000)}

\item{seed}{the seed used in random number generation (default = 1234)}
}
\value{
A scalar equal to the correlation upper bound.
}
\description{
This function calculates the upper Frechet-Hoeffding bound on the correlation between a Negative Binomial variable
    and the normal variable used to generate it.  It is used in \code{\link[SimMultiCorrData]{findintercorr_cat_nb}}
    and \code{\link[SimMultiCorrData]{findintercorr_cont_nb}} in calculating the intermediate MVN correlations.  This extends
    the method of Amatya & Demirtas (2015, \doi{10.1080/00949655.2014.953534}) to Negative Binomial variables.  This function would not ordinarily be called directly by the user.
}
\references{
Please see references for \code{\link[SimMultiCorrData]{chat_pois}}.
}
\seealso{
\code{\link[SimMultiCorrData]{findintercorr_cat_nb}}, \code{\link[SimMultiCorrData]{findintercorr_cont_nb}},
    \code{\link[SimMultiCorrData]{findintercorr}}
}
\keyword{1}
\keyword{Binomial,}
\keyword{Negative}
\keyword{correlation,}
\keyword{method}
