% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findintercorr_cat_nb.R
\name{findintercorr_cat_nb}
\alias{findintercorr_cat_nb}
\title{Calculate Intermediate MVN Correlation for Ordinal - Negative Binomial Variables: Method 1}
\usage{
findintercorr_cat_nb(rho_cat_nb, marginal, size, prob, mu = NULL,
  nrand = 100000, seed = 1234)
}
\arguments{
\item{rho_cat_nb}{a \code{k_cat x k_nb} matrix of target correlations among ordinal and Negative Binomial variables}

\item{marginal}{a list of length equal to \code{k_cat}; the i-th element is a vector of the cumulative
probabilities defining the marginal distribution of the i-th variable;
if the variable can take r values, the vector will contain r - 1 probabilities (the r-th is assumed to be 1)}

\item{size}{a vector of size parameters for the Negative Binomial variables (see \code{\link[stats]{dnbinom}})}

\item{prob}{a vector of success probability parameters}

\item{mu}{a vector of mean parameters (*Note: either \code{prob} or \code{mu} should be supplied for all Negative Binomial variables,
not a mixture; default = NULL)}

\item{nrand}{the number of random numbers to generate in calculating the bound (default = 10000)}

\item{seed}{the seed used in random number generation (default = 1234)}
}
\value{
a \code{k_cat x k_nb} matrix whose rows represent the \code{k_cat} ordinal variables and columns represent the
    \code{k_nb} Negative Binomial variables
}
\description{
This function calculates a \code{k_cat x k_nb} intermediate matrix of correlations for the k_cat ordinal (r >=
    2 categories) and k_nb Negative Binomial variables. It extends the method of Amatya & Demirtas (2015, \doi{10.1080/00949655.2014.953534})
    to ordinal - Negative Binomial pairs.  Here, the intermediate correlation between Z1 and Z2 (where Z1 is the standard normal variable
    discretized to produce an ordinal variable Y1, and Z2 is the standard normal variable used to generate a Negative Binomial
    variable via the inverse cdf method) is calculated by dividing the target correlation by a correction factor.  The
    correction factor is the product of the upper Frechet-Hoeffding bound on the correlation between a Negative Binomial variable
    and the normal variable used to generate it (see \code{\link[SimMultiCorrData]{chat_nb}}) and a simulated GSC upper bound on
    the correlation between an ordinal variable and the normal variable used to generate it (see Demirtas & Hedeker, 2011,
    \doi{10.1198/tast.2011.10090}).
    The function is used in \code{\link[SimMultiCorrData]{findintercorr}} and \code{\link[SimMultiCorrData]{rcorrvar}}.
    This function would not ordinarily be called by the user.
}
\references{
Please see references for \code{\link[SimMultiCorrData]{findintercorr_cat_pois}}
}
\seealso{
\code{\link[SimMultiCorrData]{chat_nb}},
    \code{\link[SimMultiCorrData]{findintercorr}}, \code{\link[SimMultiCorrData]{rcorrvar}}
}
\keyword{1}
\keyword{Binomial,}
\keyword{Negative}
\keyword{correlation,}
\keyword{intermediate,}
\keyword{method}
\keyword{ordinal,}
