\name{summary.hapBin}
\alias{summary.hapBin}
\alias{print.summary.hapBin}

%- Also NEED an '\alias' for EACH other topic documented here.
\title{Summarize binary haplotype analysis models}
\description{
  Summary method for objects of class \code{hapBin}
}
\usage{
\method{summary}{hapBin}(object, ...)
\method{print}{summary.hapBin}(x, digits = max(3, getOption("digits") - 3), 
	signif.stars = getOption("show.signif.stars"), ...)

}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{object}{object of class \code{hapBin}, the result of a call to \code{haplo.bin}.}
  \item{x}{an object of class \code{summary.hapBin}, the result of a call to \preformatted{summary.hapBin.}}
  \item{digits}{the number of significant digits to use when printing.}
  \item{signif.stars}{logical. If \code{TRUE}, ``significance stars" are printed for each coefficient.}
  \item{\dots}{further arguments passed to or from other methods.}
}

\value{

  \item{formula}{formula1 passed into \code{haplo.bin}.}
  \item{coefficients}{a table containing the odds ratios, confidence intervals and p-values of the parameter estimates.}
  \item{LRT}{a likelihood ratio test, testing for significant improvement of the model when haplotypic parameters are included.}
  \item{AIC}{Akaike Information Criterion for the linear model fit including haplotypes.}
  \item{empiricalResults}{a list containing the odds ratios, confidence intervals and p-values calculated at each simulation of \code{haplo.bin}.}
  \item{effect}{the haplotypic effect modelled: `ADDITIVE', `DOMINANT' or `RECESSIVE'.}
  
}
\references{
McCaskie, P.A., Carter, K.W. Hazelton, M., Palmer, L.J. (2007) SimHap: A comprehensive modeling framework for epidemiological outcomes and a multiple-imputation approach to haplotypic analysis of population-based data, [online] www.genepi.org.au/simhap.
}
\author{Pamela A. McCaskie}
\note{
See help for \code{haplo.bin} for more details.
}
\seealso{\code{\link{haplo.quant}}}
\examples{

data(SNP.dat)

# convert SNP.dat to format required by infer.haplos
haplo.dat <- SNP2Haplo(SNP.dat)

data(pheno.dat)

# generate haplotype frequencies and haplotype design matrix
myinfer<-infer.haplos(haplo.dat) 

# print haplotype frequencies generated by infer.haplos
myinfer$hap.freq

# generate haplo object where haplotypes with a frequency 
# below min.freq are grouped as a category called "rare"
myhaplo<-make.haplo.rare(myinfer,min.freq=0.05) 
mymodel <- haplo.bin(formula1=PLAQUE~AGE+SBP+h.N1AA, 
	formula2=PLAQUE~AGE+SBP, pheno=pheno.dat, haplo=myhaplo, 
	sim=10)

}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{methods}

