% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/name.correl.R
\name{name.correl}
\alias{name.correl}
\title{Help to name parameter 'correl'}
\usage{
name.correl(is.comp,is.reg,beta_fun=NULL)
}
\arguments{
\item{is.comp}{Logical. Is there competition for resources ?}

\item{is.reg}{Logical. Is there regulation between enzymes ?}

\item{beta_fun}{Numeric matrix of co-regulation coefficients. Default is NULL, but needed if there is regulation (\code{is.reg==TRUE}).}
}
\value{
A character string, used for parameter \code{correl_fun}. See possible values in \code{\link{is.correl.authorized}}.
}
\description{
Give the correct abbreviation of the applied constraint, used for parameter \code{correl_fun}
}
\details{
Explored constraints are competition and/or regulation.

If you choose to put regulation, matrix of co-regulation coefficient \code{beta} \bold{or} vector of global co-regulation coefficients \code{B} are needed.

See function \code{\link{is.correl.authorized}} to know possible value of parameter \code{correl_fun}.
}
\examples{

#Independence 
name.correl(is.comp=FALSE,is.reg=FALSE)
#returns "SC"

#Regulation
beta <- matrix(c(1,10,5,0.1,1,0.5,0.2,2,1),nrow=3)
name.correl(is.comp=FALSE,is.reg=TRUE,beta_fun=beta)
#returns "RegPos"



}
