% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flux.shape.from.one.point.graphics.R
\name{flux.shape.from.one.point.graphics}
\alias{flux.shape.from.one.point.graphics}
\title{Plots of flux shape computing from one point}
\usage{
flux.shape.from.one.point.graphics(list_fsfop, N_fun, zoom_delta=NULL,add.eq=TRUE,
gr.s.delta=TRUE,gr.J.E=FALSE,gr.s_cont.E=FALSE,gr.s_disc.E=FALSE,
gr.comp.s=FALSE,gr.tau=FALSE,posi.legend="topleft",...)
}
\arguments{
\item{list_fsfop}{Output of the function \code{\link{flux.shape.from.one.point}}}

\item{N_fun}{Numeric. Population size that influence neutral zone}

\item{zoom_delta}{Zoom on axis of apparent mutation effects. \emph{See details.}}

\item{add.eq}{Logical. Does equilibrium appear on graphics?}

\item{gr.s.delta}{Logical. Add graph of selection coefficient in relation to mutation effect?}

\item{gr.J.E}{Logical. Add graph of flux J in relation to enzyme concentrations?}

\item{gr.s_cont.E, gr.s_disc.E}{Logical. Add graph of selection coefficient (respectively from continuous or discrete expression) in relation to enzyme concentrations?}

\item{gr.comp.s}{Logical. Add graph of comparison of selection coefficient from different expressions (continuous vs discrete)?}

\item{gr.tau}{Logical. Add graph depending on tau?}

\item{posi.legend}{Legend position for activities. See \emph{details}.}

\item{...}{Arguments to be passed in \code{plot} function, such as \code{lwd} or \code{cex}.}
}
\value{
Nothing
}
\description{
Graphics for illustrating results of function \code{\link{flux.shape.from.one.point}}
}
\details{
See function \code{\link{flux.shape.from.one.point}}.

Gives graphics of:
\enumerate{
   \item Selection coefficient (discrete expression) in relation to apparent mutation effect \eqn{\delta}, which is \eqn{E^m-E^r} (option \code{gr.s.delta})
   \item Flux in relation to mutant concentration \eqn{E^m} (option \code{gr.J.E})
   \item Selection coefficient (continuous expression) in relation to mutant concentration (option \code{gr.s_cont.E})
   \item Selection coefficient (discrete expression) in relation to mutant concentration (option \code{gr.s_disc.E})
   \item Comparison between the two expressions of selection coefficient (option \code{gr.comp.s})
   \item If driving variable \eqn{\tau} exists: flux/mutant concentrations/discrete selection coefficient in relation to tau (option \code{gr.tau})
}

Each enzyme is represented by one color. If there are three enzymes enzymes or less, enzyme 1 is in red, 2 in green and 3 in blue.
For more than three enzymes, colors are taken in palette \code{"Spectral"} from package '\code{RColorBrewer}'.


\emph{Discrete expression} of selection coefficient refers to \eqn{s=(J^m-J^r)/J^r}. Available whatever values of enzymes concentrations. See function \code{\link{coef_sel.discrete}}.
\emph{Continuous expression} of selection coefficient refers to \eqn{s_i = R_Ei^J delta_i/E_i}. Available only for small values of delta_i. See function \code{\link{coef_sel.continue}}.


The RNV corresponds to enzyme concentrations such as selection coefficient is between -1/N and 1/N.
  
 \bold{Zooms}
  
 If \code{NULL}, default values are applied.
 
 If vector of length 1, symmetry is applied (i.e. -zoom,zoom).
 
 If vector of length 2, zoom values are applied directly.
 
 \bold{posi.legend}
 
 Indicates coordinates of the upper left corner of the legend.
 Available only for graph corresponding to \code{gr.s.delta}.
 See more in details of function \code{\link{flux.dome.projections}}.
}
\examples{
\donttest{
fsfop <- flux.shape.from.one.point(100,c(1,10,30),"SC")
flux.shape.from.one.point.graphics(fsfop,1000)
}

}
\seealso{
See function \code{\link{RNV.ranking.order.factor}} to see against which parameters the RNV depend.
}
